/*
 * Cell program (sample)
 */

#include <math.h>
#include <ccell.c7.h>

#define NPROC		64	/* number of processors */
#define MAX_PSIZE	2048	/* maximum size of problem */

#define ROW_SIZE	MAX_PSIZE
#define COL_SIZE	((MAX_PSIZE+NPROC-1)/NPROC)
#define VEC_SIZE	((MAX_PSIZE+NPROC-1)/NPROC)

/* matrix A */
/*
    A ιԤϡ2 matrix_A Τ줾
       : 1
       : 2
   ˥ޥåԥ󥰤뤳Ȥ generate_c, check_c 
   Ƥޤ
*/
double matrix_A[COL_SIZE][ROW_SIZE];

/* vector B */
double vector_B[VEC_SIZE];

/* vector X */
double vector_X[VEC_SIZE];

void
cell_main()
{
    int key;
    int p_size, ma_row, ma_col;

    /* get problem key */
    recvkey_c(&key);

    /* generate matrix A and vector B */
    if (!generate_c(key,	/* Υֹ */
		    matrix_A,	/*  A */
		    ROW_SIZE,	/*  A γݤ󥵥 */
		    COL_SIZE,	/*  A γݤԥ */
		    vector_B,	/* ٥ȥ B */
		    VEC_SIZE,	/* ٥ȥ B γݤ */
		    &p_size,	/* ꥵ () */
		    &ma_row,	/*  A ô󥵥 () */
		    &ma_col	/*  A ôԥ () */
		    )) {
	/* error */
	cell_exit(1);
    }

/*
   ϢΩ Ax = B βץ񤭤ޤ
   ξ vector_X ˲٥ȥǼƤ
   ʤ٥ȥ vector_X ʬϥ٥ȥ B ʬƱ
   ˤƤ
*/
    if (getcid() == 0)
	printf("size = %d, ma_row = %d, ma_col = %d\n",
		p_size, ma_row, ma_col);
    solve_mat(p_size, matrix_A, vector_B, vector_X);

    /* check vector X */
    check_c(key,		/* Υֹ */
	    matrix_A,		/*  A */
	    ROW_SIZE,		/*  A γݤ󥵥 */
	    COL_SIZE,		/*  A γݤԥ */
	    vector_B,		/* ٥ȥ B */
	    VEC_SIZE,		/* ٥ȥ B γݤ */
	    vector_X,		/* ٥ȥ X */
	    VEC_SIZE);		/* ٥ȥ X γݤ */
}
