/*
 *  Solve a block-distributed matrix for the AP+
 */

#include "conf.h"
#include "dist.h"

/*
 *  Redistributed matrix and the answer vector
 */

dot_mat pB;
static double x[N];

int tid;

void
copy_x(cid, size, x, local_x)
int cid;
int size;
double *x, *local_x;
{
    int n = num_in_proc_block(cid, size);

    bcopy(&x[toglobal_block(cid, 0, size)],
	  local_x,
	  n * sizeof(double));
}

void
solve_mat(size, pA, b, local_x)
    int size;
    mat pA;
    double *b, *local_x;
{
    int i;
    int cid;

    cid = getcid();
    tid = gettid();

    init_LU(cid, size);

    trans_block_dot_mat_vec(cid, tid, size, pA, b, pB);

    gauss(cid, size, pB);

#if 1
    solve_U(cid, size, pB, x);
#else
    trans_dot_block_mat_vec(cid, size, pB, pA);
    solve_U_block(cid, size, pA, x);
#endif

    copy_x(cid, size, x, local_x);
}
