/*
 *  modified from LINPACK auxiliary routine 8/8/95 by Osamu Tatebe
 */

#include "conf.h"
#include "dist.h"
#include "dot.h"
#include "misc.h"

static double ran();

/* special macro */
#define dmax1(a, b) \
        ((a) > (b) ? (a) : (b))
#define dabs(a) fabs(a)
extern double fabs();


static int count_rand;

/*  get i'th element of coefficient matrix  */
double get_elemt(i, init)
int i;
int init[];
{
    while (i > count_rand) {
	ran(init);
	count_rand++;
    }
    return ran(init);
}

/*
  generate matrix 

  parameters:
        a       matrix
        n       the size of matrix
        norma   the maximum element of the matrix 'a'
 */

void
matgen(cid, a, n, norma)
int cid;
dot_mat a;
int n;
double* norma;
{
    static int init[5];
    int i, j;
    int cidx, cidy;
    int nx, ny;
    double maxa;
    count_rand = 0;

    init[1] = 1;
    init[2] = 2;
    init[3] = 3;
    init[4] = 1325;
    maxa = 0.0;
    lin_trec(cid, cidx, cidy);
    nx = num_in_proc_x(cidx, n);
    ny = num_in_proc_y(cidy, n);
    for (j = 0; j < nx; j++) {
	int g_j = toglobal_x(cidx, j, n);
	for (i = 0; i < ny; i++) {
	    int g_i = toglobal_y(cidy, i, n);
	    a[i][j] = get_elemt(g_i * n + g_j, init) - .5;
            maxa = dmax1(dabs(a[i][j]), maxa);
	}
    }

    *norma = maxa;

    for (i = 0; i < ny; i++) {
	double tmp_b = 0;
	double b;
	for (j = 0; j < nx; j++)
            tmp_b += a[i][j];
	dsum_x(cid, tmp_b, &b);
	a[i][nx] = b;
    }
}

static double ran(ISEED)
/*
 *
 *     modified from the LAPACK auxiliary routine 10/12/92 JD
 *  -- LAPACK auxiliary routine (version 1.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     February 29, 1992
 *
 *     .. Array Arguments ..
 */
int ISEED[5];
/*
 *     ..
 *
 *  Purpose
 *  =======
 *
 *  DLARAN returns a random real number from a uniform (0,1)
 *  distribution.
 *
 *  Arguments
 *  =========
 *
 *  ISEED   (input/output) INTEGER array, dimension (4)
 *          On entry, the seed of the random number generator; the array
 *          elements must be between 0 and 4095, and ISEED(4) must be
 *          odd.
 *          On exit, the seed is updated.
 *
 *  Further Details
 *  ===============
 *
 *  This routine uses a multiplicative congruential method with modulus
 *  2**48 and multiplier 33952834046453 (see G.S.Fishman,
 *  'Multiplicative congruential random number generators with modulus
 *  2**b: an exhaustive analysis for b = 32 and a partial analysis for
 *  b = 48', Math. Comp. 189, pp 331-344, 1990).
 *
 *  48-bit integers are stored in 4 integer array elements with 12 bits
 *  per element. Hence the routine is portable across machines with
 *  integers of 32 bits or more.
 *
 *     .. Parameters ..
 */
#define M1      494
#define M2      322
#define M3      2508
#define M4      2549
#define ONE     1.0
#define IPW2    4096
#define R       (ONE / IPW2)
{
/*
 *     ..
 *     .. Local Scalars ..
 */
    int            IT1, IT2, IT3, IT4;
/*
 *     ..
 *     .. Intrinsic Functions ..
 */
/*      INTRINSIC          DBLE, MOD */
/*
 *     ..
 *     .. Executable Statements ..
 *
 *     multiply the seed by the multiplier modulo 2**48
 *
 */
    IT4 = ISEED[4] * M4;
    IT3 = IT4 / IPW2;
    IT4 = IT4 - IPW2 * IT3;
    IT3 = IT3 + ISEED[3] * M4 + ISEED[4] * M3;
    IT2 = IT3 / IPW2;
    IT3 = IT3 - IPW2 * IT2;
    IT2 = IT2 + ISEED[2] * M4 + ISEED[3] * M3 + ISEED[4] * M2;
    IT1 = IT2 / IPW2;
    IT2 = IT2 - IPW2 * IT1;
    IT1 = IT1 + ISEED[1] * M4 + ISEED[2] * M3 + ISEED[3] * M2 +
        ISEED[4] * M1;
    IT1 = IT1 % IPW2;
/*
 *
 *     return updated seed
 *
 */
    ISEED[1] = IT1;
    ISEED[2] = IT2;
    ISEED[3] = IT3;
    ISEED[4] = IT4;
/*
 *
 *     convert 48-bit integer to a real number in the interval (0,1)
 *
 */
    return R * ((double)IT1 + R * ((double)IT2 + R * ((double)IT3 + R * 
                                                      ((double)IT4))));
/*
 *
 *     End of RAN
 *
 */
}
