#include <stdio.h>
#include <math.h>
#include "conf.h"
#include "dist.h"
#include "dot.h"
#include "misc.h"

/*  seed of random number  */

/*static int ir;*/
static unsigned int ir;
static int count_rand;

/*  get i'th element of coefficient matrix  */

double get_element(i)
int i;
{
    while (i >= count_rand) {
/*	ir = ( 1229 * ir + 351750 ) % 1664501 ; */
	ir = 1812433253 * ir;
	count_rand++;
    }
/*    return (double)ir / 1664501.0 ; */
    return .5 * (double)ir / (double)(unsigned long)0x80000000;
}

/*
 *  set matrix.  the right hand vector is stored to the rightmost
 *  column of A
 */

void
generate_matrix(cid, size, A)
int cid;
int size;
dot_mat A;
{
    int cidx, cidy;
    int nx, ny;
    int i, j;
    int base;

    ir = 2001;
    count_rand = 0;

    lin_trec(cid, cidx, cidy);
    nx = num_in_proc_x(cidx, size);
    ny = num_in_proc_y(cidy, size);
    for (i = 0; i < ny; i++) {
	int g_i = toglobal_y(cidy, i, size);
	for (j = 0; j < nx; j++) {
	    int g_j = toglobal_x(cidx, j, size);
	    A[i][j] = get_element(g_i * size + g_j);
	}
    }
    base = size * size;
    for (i = 0; i < ny; i++) {
	int g_i = toglobal_y(cidy, i, size);
	A[i][nx] = get_element(base + g_i);
    }
}


static double y[N];

/* x is a whole vector */

double calc_residual(cid, size, A, x)
int cid;
int size;
dot_mat A;
double *x;
{
    int cidx, cidy;
    int nx, ny;
    int i, j;
    double r = 0, t;

    lin_trec(cid, cidx, cidy);
    nx = num_in_proc_x(cidx, size);
    ny = num_in_proc_y(cidy, size);
    for (i = 0; i < ny; i++) {
	int g_i = toglobal_y(cidy, i, size);
	double tmp_y = 0;
	for (j = 0; j < nx; j++) {
	    int g_j = toglobal_x(cidx, j, size);
	    tmp_y += A[i][j] * x[g_j];
	}
	y[g_i] = tmp_y;
    }
    for (i = 0; i < ny; i++) {
	int g_i = toglobal_y(cidy, i, size);
	double z;
	dsum_x(cid, y[g_i], &z);
	y[g_i] = z;
    }
    for (i = 0; i < ny; i++) {
	int g_i = toglobal_y(cidy, i, size);
	double tmp_r = A[i][nx] - y[g_i];
	r += tmp_r * tmp_r;
    }
    dsum_y(cid, r, &t);
    return sqrt(t);
}

void
copy_matrix(cid, size, A, B)
int cid;
int size;
dot_mat A, B;
{
    int cidx, cidy;
    int nx, ny;
    int i, j;

    lin_trec(cid, cidx, cidy);
    nx = num_in_proc_x(cidx, size);
    ny = num_in_proc_y(cidy, size);
    for (i = 0; i < ny; i++) {
	bcopy(A[i], B[i], (nx + 1) * sizeof(double));
    }
}

void
print_matrix(cid, size, A)
int cid;
int size;
dot_mat A;
{
    int cidx, cidy;
    int nx, ny;
    int i, j;

    lin_trec(cid, cidx, cidy);
    nx = num_in_proc_x(cidx, size);
    ny = num_in_proc_y(cidy, size);
    for (i = 0; i < ny; i++) {
	int g_i = toglobal_y(cidy, i, size);
	printf("A[%d] =", g_i);
	for (j = 0; j < nx; j++) {
	    int g_j = toglobal_x(cidx, i, size);
	    printf(" %f", A[i][j]);
	}
	puts("");
    }

    for (i = 0; i < ny; i++) {
	int g_i = toglobal_y(cidy, i, size);
	printf("b[%d] = %f\n", g_i, A[i][nx]);
    }
}
