/* sample program */

#define LINPACK

#include <stdio.h>
#ifdef __MPI__
#include <mpi.h>
#endif

#include "conf.h"

#ifdef __AP__
extern double dgettime();
int tid;
#define MPI_Wtime()	dgettime()
#define MPI_Barrier(c)	sync(0, 0)
#endif

#ifndef EMX
#define resched()
#define lock0()
#define unlock0()
#endif

extern double calc_residual();

dot_mat A;
double x[N];

#ifdef __MPI__
main(argc, argv)
    int argc;
    char* argv[];
#elif defined(__AP__)
cell_main()
#else
#error Define either __MPI__ or __AP__
#endif
{
    int size = 100;
    int cid, npe;
    double norma;
    double r;
    double time;
    double max, min, ave;
#ifdef __AP__
    int max_cid, min_cid;
#endif

#ifdef __MPI__

#ifdef __CENJU__
    mpi_set_nr(NUM_PROC);
    MPI_Init();
#else
    MPI_Init(&argc, &argv);
#endif

    argc--, argv++;
    while (argc > 0) {
	if (argv[0][0] == '-') {
	    switch (argv[0][1]) {
	    case 's':
		argc--, argv++;
		size = atoi(argv[0]);
		break;
	    }
	}
	argc--, argv++;
    }

    MPI_Comm_rank(MPI_COMM_WORLD, &cid);
    MPI_Comm_size(MPI_COMM_WORLD, &npe);

    if (npe != NUM_PROC) {
	if (cid == 0) {
	    lock0();
	    printf("You should allocate %d procs\n", NUM_PROC);
	    unlock0();
	}
	MPI_Finalize();
	exit(1);
    }
#else /* ifdef __AP__ */
    cid = getcid();
    tid = gettid();
    npe = getncel();
#endif

    if (cid == 0) {
	lock0();
	printf("size = %d\n", size);
	unlock0();
    }

#ifdef LINPACK
    matgen(cid, A, size, &norma);
#else
    generate_matrix(cid, size, A);
#endif
    MPI_Barrier(MPI_COMM_WORLD);
    time = MPI_Wtime();

    solve_matrix(cid, size, A, x);

    time = MPI_Wtime() - time;

#ifdef LINPACK
    matgen(cid, A, size, &norma);
#else
    generate_matrix(cid, size, A);
#endif

    r = calc_residual(cid, size, A, x);

#if defined(__CENJU__) || defined(__MPI__)
    MPI_Reduce(&time, &max, 1, MPI_DOUBLE,
	       MPI_MAX, 0, MPI_COMM_WORLD);
    MPI_Reduce(&time, &min, 1, MPI_DOUBLE,
	       MPI_MIN, 0, MPI_COMM_WORLD);
    MPI_Reduce(&time, &ave, 1, MPI_DOUBLE,
	       MPI_SUM, 0, MPI_COMM_WORLD);
#else /* ifdef __AP__ */
    xy_dmax(time, cid, &max, &max_cid);
    xy_dmin(time, cid, &min, &min_cid);
    xy_dsum(time, &ave);
#endif

    lock0();
    if (cid == 0) {
	ave = ave / npe;

	printf("residual = %g\n", r);
	printf("time = %f\n", max);
	printf("min = %f, ave = %f\n", min, ave);
	printf("%g MFlops\n",
	       .000001 * (2.0 * size * size * size / 3.0 + 2.0 * size * size) / max);
    }
    unlock0();

#ifdef __MPI__
    MPI_Finalize();
#endif
}
