/*
 *  broadcast library
 */

static char rcsid[] = "$Id: broad.c,v 1.2 1998/07/03 08:35:52 tatebe Exp $";

#include <sys/types.h>

#define USE_BROAD

#ifdef __MPI__
#include <mpi.h>
#endif
#ifdef __AP__
#include <ccell.c7.h>
#endif

#include "conf.h"

#ifdef __AP__
extern int tid;
#endif

void
broad_send_double(cid, type, src)
int cid, type;
double *src;
{
#ifdef __MPI__
    int i;
    MPI_Request req;

    for (i = 1; i < NUM_PROC; i <<= 1) {
	MPI_Isend(src, 1, MPI_DOUBLE,
		  cid ^ i, type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
    }
#elif defined(__AP__)
#ifndef USE_BROAD
    int i;
    for (i = 1; i < NUM_PROC; i <<= 1) {
	l_asend(cid ^ i, tid, type, src, sizeof(double));
    }
#else /* USE_BROAD */
    cbroad(tid, type, src, sizeof(double));
#endif
#endif /* __AP__ */
}

void
broad_recv_double(cid, type, src)
int cid, type;
double *src;
{
#ifdef __MPI__
    int i;
    MPI_Status status;
    MPI_Request req;

    MPI_Recv(src, 1, MPI_DOUBLE,
	     MPI_ANY_SOURCE, type,
	     MPI_COMM_WORLD, &status);
    i = (status.MPI_SOURCE ^ cid);
    for (i <<= 1; i < NUM_PROC; i <<= 1) {
	MPI_Isend(src, 1, MPI_DOUBLE,
		  cid ^ i, type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
    }
#elif defined(__AP__)
#ifndef USE_BROAD
    int i;

    /* *src = *((double*) */ l_arecv(ANY_CELL, tid, type);
    readmsg(src, sizeof(double));
    i = getmcid() ^ cid;

    for (i <<= 1; i < NUM_PROC; i <<= 1) {
	l_asend(cid ^ i, tid, type, src, sizeof(double));
    }
#else /* USE_BROAD */
    /* *src = *((double*) */ l_arecv(ANY_CELL, tid, type);
    readmsg(src, sizeof(double));
#endif
#endif /* __AP__ */
}
