static char rcsid[] = "$Id: broad_put.c,v 1.1 1996/11/05 09:09:07 tatebe Exp $";

#ifdef __AP__
#ifdef __BROAD_PUT__

#include <ccell.c7.h>
#include <sys/types.h>

extern u_long *put_sendq;
extern u_long *get_sendq;
extern u_long *xy_gbrd_sendq;
extern u_long *x_gbrd_sendq;
extern u_long *y_gbrd_sendq;

extern u_long x_brd_head;
extern u_long y_brd_head;
extern u_long xy_brd_head;

void
broad_put(src, size, dest, put_f, dma_f)
    u_long *src;
    long size;
    u_long *dest;
    u_long *put_f, *dma_f;
{
    *xy_gbrd_sendq = (u_long)xy_brd_head;	/* $BAjBP%G%9%F%#%M!<%7%g%s%;%k%"%I%l%9(B */
    *xy_gbrd_sendq = (u_long)size;		/* $BE>Aw%5%$%:(B:$B%o!<%IC10L(B */
    *xy_gbrd_sendq = (u_long)dest;		/* $B%G%9%F%#%M!<%7%g%s%"%I%l%9(B */
    *xy_gbrd_sendq = (u_long)0;			/* $B%G%9%F%#%M!<%7%g%sB&%9%H%i%$%I%Q%i%a!<%?(B */
    *xy_gbrd_sendq = (u_long)put_f;		/* $B%G%9%F%#%M!<%7%g%s%U%i%0%"%I%l%9(B */
    *xy_gbrd_sendq = (u_long)dma_f;		/* $B%=!<%9%U%i%0%"%I%l%9(B */
    *xy_gbrd_sendq = (u_long)src;		/* $B%=!<%9%"%I%l%9(B */
    *xy_gbrd_sendq = (u_long)0;			/* $B%=!<%9B&%9%H%i%$%I%Q%i%a!<%?(B */
}

void
x_broad_put(src, size, dest, put_f, dma_f)
    u_long *src;
    long size;
    u_long *dest;
    u_long *put_f, *dma_f;
{
    *x_gbrd_sendq = (u_long)x_brd_head;		/* $BAjBP%G%9%F%#%M!<%7%g%s%;%k%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)size;		/* $BE>Aw%5%$%:(B:$B%o!<%IC10L(B */
    *x_gbrd_sendq = (u_long)dest;		/* $B%G%9%F%#%M!<%7%g%s%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)0;			/* $B%G%9%F%#%M!<%7%g%sB&%9%H%i%$%I%Q%i%a!<%?(B */
    *x_gbrd_sendq = (u_long)put_f;		/* $B%G%9%F%#%M!<%7%g%s%U%i%0%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)dma_f;		/* $B%=!<%9%U%i%0%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)src;		/* $B%=!<%9%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)0;			/* $B%=!<%9B&%9%H%i%$%I%Q%i%a!<%?(B */
}

void
y_broad_put(src, size, dest, put_f, dma_f)
    u_long *src;
    long size;
    u_long *dest;
    u_long *put_f, *dma_f;
{
    *y_gbrd_sendq = (u_long)y_brd_head;		/* $BAjBP%G%9%F%#%M!<%7%g%s%;%k%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)size;		/* $BE>Aw%5%$%:(B:$B%o!<%IC10L(B */
    *y_gbrd_sendq = (u_long)dest;		/* $B%G%9%F%#%M!<%7%g%s%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)0;			/* $B%G%9%F%#%M!<%7%g%sB&%9%H%i%$%I%Q%i%a!<%?(B */
    *y_gbrd_sendq = (u_long)put_f;		/* $B%G%9%F%#%M!<%7%g%s%U%i%0%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)dma_f;		/* $B%=!<%9%U%i%0%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)src;		/* $B%=!<%9%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)0;			/* $B%=!<%9B&%9%H%i%$%I%Q%i%a!<%?(B */
}

void
x_broad_put_stride(src, size, src_item_size, src_stride_width,
		   dest, dest_item_size, dest_stride_width,
		   put_f, dma_f)
    u_long *src;
    long size, src_item_size, src_stride_width;
    u_long *dest;
    long dest_item_size, dest_stride_width;
    u_long *put_f, *dma_f;
{
    *x_gbrd_sendq = (u_long)x_brd_head;		/* $BAjBP%G%9%F%#%M!<%7%g%s%;%k%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)size;		/* $BE>Aw%5%$%:(B:$B%o!<%IC10L(B */
    *x_gbrd_sendq = (u_long)dest;		/* $B%G%9%F%#%M!<%7%g%s%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)dest_item_size << 24 | dest_stride_width;
						/* $B%G%9%F%#%M!<%7%g%sB&%9%H%i%$%I%Q%i%a!<%?(B
						   :$B$$$:$l$b%o!<%IC10L(B */
    *x_gbrd_sendq = (u_long)put_f;		/* $B%G%9%F%#%M!<%7%g%s%U%i%0%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)dma_f;		/* $B%=!<%9%U%i%0%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)src;		/* $B%=!<%9%"%I%l%9(B */
    *x_gbrd_sendq = (u_long)src_item_size << 24 | src_stride_width;
						/* $B%=!<%9B&%9%H%i%$%I%Q%i%a!<%?(B */
}

void
y_broad_put_stride(src, size, src_item_size, src_stride_width,
		   dest, dest_item_size, dest_stride_width,
		   put_f, dma_f)
    u_long *src;
    long size, src_item_size, src_stride_width;
    u_long *dest;
    long dest_item_size, dest_stride_width;
    u_long *put_f, *dma_f;
{
    *y_gbrd_sendq = (u_long)y_brd_head;		/* $BAjBP%G%9%F%#%M!<%7%g%s%;%k%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)size;		/* $BE>Aw%5%$%:(B:$B%o!<%IC10L(B */
    *y_gbrd_sendq = (u_long)dest;		/* $B%G%9%F%#%M!<%7%g%s%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)dest_item_size << 24 | dest_stride_width;
						/* $B%G%9%F%#%M!<%7%g%sB&%9%H%i%$%I%Q%i%a!<%?(B 
						   :$B$$$:$l$b%o!<%IC10L(B */
    *y_gbrd_sendq = (u_long)put_f;		/* $B%G%9%F%#%M!<%7%g%s%U%i%0%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)dma_f;		/* $B%=!<%9%U%i%0%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)src;		/* $B%=!<%9%"%I%l%9(B */
    *y_gbrd_sendq = (u_long)src_item_size << 24 | src_stride_width;
						/* $B%=!<%9B&%9%H%i%$%I%Q%i%a!<%?(B */
}


#if 0
static u_long put_f = 0, dma_f = 0;
static int src = 10, dest = 0;

double sdata[10];
double rdata[10];

cell_main()
{
    int i;
    int cid = getcid();
    int cidx, cidy;

    if (cid == 0)
	for (i = 0; i < 10; i++)
	    sdata[i] = i + 1;
    lin_trec(cid, &cidx, &cidy);
    if (cid == 0) {
	x_broad_put_stride(sdata, 5 * 2, 2 * 2, 1 * 2, rdata, 5 * 2, 0, 
			   &put_f, &dma_f);
	amcheck(&dma_f, 1);
	puts("broadcast is over");
    }
    else if (cidy == 0) {
	puts("now waiting...");
	amcheck(&put_f, 1);
	for (i = 0; i < 10; i++)
	    printf("%f\n", rdata[i]);
    }
}
#endif

#endif
#endif
