/*
 *  broadcast library for X-direction
 */

static char rcsid[] = "$Id: broad_x.c,v 1.5 1998/07/29 11:05:40 tatebe Exp $";

#ifdef __MPI__
#include <mpi.h>
#endif
#ifdef __AP__
#include <ccell.c7.h>
#endif

#include "conf.h"
#include "misc.h"

#ifdef __AP__
extern int tid;
#endif

/*#define LOG_BROAD*/

void
broad_send_x(cid, type, src, size)
int cid, type;
char *src;
int size;
{
    int i;

#ifdef LOG_BROAD
    for (i = 1; i < NUM_PROC_X; i <<= 1) {
#ifdef __MPI__
	MPI_Request req;
	MPI_Isend(src, size, MPI_BYTE,
		  cid ^ i, type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(cid ^ i, tid, type, src, size);
#endif
    }
#else /* SER_BROAD */
    int cidx, cidy;
    lin_trec(cid, cidx, cidy);
    for (i = cidx + 1; i < NUM_PROC_X; i++) {
#ifdef __MPI__
	MPI_Request req;
	MPI_Isend(src, size, MPI_BYTE,
		  rec_tlin(i, cidy), type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(rec_tlin(i, cidy), tid, type, src, size);
#endif
    }
    for (i = 0; i < cidx; i++) {
#ifdef __MPI__
	MPI_Request req;
	MPI_Isend(src, size, MPI_BYTE,
		  rec_tlin(i, cidy), type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(rec_tlin(i, cidy), tid, type, src, size);
#endif
    }
#endif
}

void
broad_recv_x(cid, type, src, size)
int cid, type;
char *src;
int size;
{
    int msg_size;
#ifdef __MPI__
    MPI_Status status;

    MPI_Recv(src, size, MPI_BYTE,
	     MPI_ANY_SOURCE, type,
	     MPI_COMM_WORLD, &status);
#elif defined(__AP__)
    l_arecv(ANY_CELL, tid, type);
    msg_size = getmsize();
    readmsg(src, msg_size);
#endif

#ifdef LOG_BROAD
    {
	int i;
	int sid;

#ifdef __MPI__
	MPI_Get_count(&status, MPI_BYTE, &msg_size);

	sid = status.MPI_SOURCE;
#elif defined(__AP__)
	sid = getmcid();
#endif
	i = (sid ^ cid);

	for (i <<= 1; i < NUM_PROC_X; i <<= 1) {
#ifdef __MPI__
	    MPI_Request req;
	    MPI_Isend(src, msg_size, MPI_BYTE,
		      cid ^ i, type,
		      MPI_COMM_WORLD, &req);
	    MPI_Request_free(&req);
#elif defined(__AP__)
	    l_asend(cid ^ i, tid, type, src, msg_size);
#endif
	}
    }
#endif
}

/*
 *
 */

void
broad_bsend_x(cid, type, src, size)
int cid, type;
char *src;
int size;
{
    int i;

#ifdef LOG_BROAD
    for (i = 1; i < NUM_PROC_X; i <<= 1) {
#ifdef __MPI__
	MPI_Send(src, size, MPI_BYTE,
		 cid ^ i, type, MPI_COMM_WORLD);
#elif defined(__AP__)
	l_asend(cid ^ i, tid, type, src, size);
#endif
    }
#else /* SER_BROAD */
    int cidx, cidy;
    lin_trec(cid, cidx, cidy);
    for (i = cidx + 1; i < NUM_PROC_X; i++) {
#ifdef __MPI__
	MPI_Send(src, size, MPI_BYTE,
		 rec_tlin(i, cidy), type, MPI_COMM_WORLD);
#elif defined(__AP__)
	l_asend(rec_tlin(i, cidy), tid, type, src, size);
#endif
    }
    for (i = 0; i < cidx; i++) {
#ifdef __MPI__
	MPI_Send(src, size, MPI_BYTE,
		 rec_tlin(i, cidy), type, MPI_COMM_WORLD);
#elif defined(__AP__)
	l_asend(rec_tlin(i, cidy), tid, type, src, size);
#endif
    }
#endif
}

void
broad_brecv_x(cid, type, src, size)
int cid, type;
char *src;
int size;
{
    int msg_size;
#ifdef __MPI__
    MPI_Status status;

    MPI_Recv(src, size, MPI_BYTE,
	     MPI_ANY_SOURCE, type,
	     MPI_COMM_WORLD, &status);
#elif defined(__AP__)
    l_arecv(ANY_CELL, tid, type);
    msg_size = getmsize();
    readmsg(src, msg_size);
#endif

#ifdef LOG_BROAD
    {
	int i;
	int sid;

#ifdef __MPI__
	MPI_Get_count(&status, MPI_BYTE, &msg_size);

	sid = status.MPI_SOURCE;
#elif defined(__AP__)
	sid = getmcid();
#endif
	i = (sid ^ cid);

	for (i <<= 1; i < NUM_PROC_X; i <<= 1) {
#ifdef __MPI__
	    MPI_Send(src, msg_size, MPI_BYTE,
		     cid ^ i, type, MPI_COMM_WORLD);
#elif defined(__AP__)
	    l_asend(cid ^ i, tid, type, src, msg_size);
#endif
	}
    }
#endif
}

/*
 * Fast receive routine for broadcast
 *
 * This function does not copy received messages, so supporsed by only
 * AP.
 */

#ifndef COPY_RECV_MSG

char*
fbroad_recv_x(cid, type)
int cid, type;
{
    int msg_size;
#ifdef LOG_BROAD
    int i;
    int sid;
#endif
    char* recv_buf;
#ifdef __AP__
    recv_buf = l_arecv(ANY_CELL, tid, type);
#endif

#ifdef LOG_BROAD
    msg_size = getmsize();
#ifdef __AP__
    sid = getmcid();
#endif
    i = (sid ^ cid);

    for (i <<= 1; i < NUM_PROC_X; i <<= 1) {
#ifdef __AP__
	l_asend(cid ^ i, tid, type, recv_buf, msg_size);
#endif
    }
#endif
    return recv_buf;
}

#endif /* COPY_RECV_MSG */
