/*
 *  broadcast library for Y-direction
 */

static char rcsid[] = "$Id: broad_y.c,v 1.7 1998/07/30 02:38:13 tatebe Exp $";

#ifdef __MPI__
#include <mpi.h>
#endif
#ifdef __AP__
#include <ccell.c7.h>
#endif

#include "conf.h"
#include "misc.h"

#ifdef __AP__
extern int tid;
#endif

/*#define LOG_BROAD*/

void
broad_send_int_y(cid, type, src)
int cid, type;
int *src;
{
    int i;
#ifdef __MPI__
    MPI_Request req;
#endif

#ifdef LOG_BROAD
    for (i = NUM_PROC_X; i < NUM_PROC; i <<= 1) {
#ifdef __MPI__
	MPI_Isend(src, 1, MPI_INT,
		  cid ^ i, type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(cid ^ i, tid, type, src, sizeof(int));
#endif
    }
#else /* SER_BROAD */
    int cidx, cidy;
    lin_trec(cid, cidx, cidy);
    for (i = cidy + 1; i < NUM_PROC_Y; i++) {
#ifdef __MPI__
	MPI_Isend(src, 1, MPI_INT,
		  rec_tlin(cidx, i), type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(rec_tlin(cidx, i), tid, type, src, sizeof(int));
#endif
    }
    for (i = 0; i < cidy; i++) {
#ifdef __MPI__
	MPI_Isend(src, 1, MPI_INT,
		  rec_tlin(cidx, i), type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(rec_tlin(cidx, i), tid, type, src, sizeof(int));
#endif
    }
#endif
}

void
broad_recv_int_y(cid, type, src)
int cid, type;
int *src;
{
#ifdef LOG_BROAD
    int i;
#endif

#ifdef __MPI__
    MPI_Status status;
    MPI_Request req;

    MPI_Recv(src, 1, MPI_INT,
	     MPI_ANY_SOURCE, type,
	     MPI_COMM_WORLD, &status);
#elif defined(__AP__)
    /* *src = *((int*) */ l_arecv(ANY_CELL, tid, type);
    readmsg(src, sizeof(int));
#endif

#ifdef LOG_BROAD
#ifdef __MPI__
    i = (status.MPI_SOURCE ^ cid);
#elif defined(__AP__)
    i = getmcid() ^ cid;
#endif
    for (i <<= 1; i < NUM_PROC; i <<= 1) {
#ifdef __MPI__
	MPI_Isend(src, 1, MPI_INT,
		  cid ^ i, type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(cid ^ i, tid, type, src, sizeof(int));
#endif
    }
#endif
}

void
broad_send_double_y(cid, type, src)
int cid, type;
double *src;
{
    int i;
#ifdef __MPI__
    MPI_Request req;
#endif

#ifdef LOG_BROAD
    for (i = NUM_PROC_X; i < NUM_PROC; i <<= 1) {
#ifdef __MPI__
	MPI_Isend(src, 1, MPI_DOUBLE,
		  cid ^ i, type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(cid ^ i, tid, type, src, sizeof(double));
#endif
    }
#else /* SER_BROAD */
    int cidx, cidy;
    lin_trec(cid, cidx, cidy);
    for (i = cidy + 1; i < NUM_PROC_Y; i++) {
#ifdef __MPI__
	MPI_Isend(src, 1, MPI_DOUBLE,
		  rec_tlin(cidx, i), type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(rec_tlin(cidx, i), tid, type, src, sizeof(double));
#endif
    }
    for (i = 0; i < cidy; i++) {
#ifdef __MPI__
	MPI_Isend(src, 1, MPI_DOUBLE,
		  rec_tlin(cidx, i), type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(rec_tlin(cidx, i), tid, type, src, sizeof(double));
#endif
    }
#endif
}

void
broad_recv_double_y(cid, type, src)
int cid, type;
double *src;
{
#ifdef LOG_BROAD
    int i;
#endif

#ifdef __MPI__
    MPI_Status status;
    MPI_Request req;

    MPI_Recv(src, 1, MPI_DOUBLE,
	     MPI_ANY_SOURCE, type,
	     MPI_COMM_WORLD, &status);
#elif defined(__AP__)
    *src = *((double*)l_arecv(ANY_CELL, tid, type));
/*    readmsg(src, sizeof(double)); */
#endif

#ifdef LOG_BROAD
#ifdef __MPI__
    i = (status.MPI_SOURCE ^ cid);
#elif defined(__AP__)
    i = getmcid() ^ cid;
#endif
    for (i <<= 1; i < NUM_PROC; i <<= 1) {
#ifdef __MPI__
	MPI_Isend(src, 1, MPI_DOUBLE,
		  cid ^ i, type,
		  MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(cid ^ i, tid, type, src, sizeof(double));
#endif
    }
#endif
}

/*
 *
 */

void
broad_send_y(cid, type, src, size)
int cid, type;
char *src;
int size;
{
    int i;

#ifdef LOG_BROAD
    for (i = NUM_PROC_X; i < NUM_PROC; i <<= 1) {
#ifdef __MPI__
	MPI_Request req;
	MPI_Isend(src, size, MPI_BYTE,
		  cid ^ i, type, MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(cid ^ i, tid, type, src, size);
#endif
    }
#else /* SER_BROAD */
    int cidx, cidy;
    lin_trec(cid, cidx, cidy);
    for (i = cidy + 1; i < NUM_PROC_Y; i++) {
#ifdef __MPI__
	MPI_Request req;
	MPI_Isend(src, size, MPI_BYTE,
		  rec_tlin(cidx, i), type, MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(rec_tlin(cidx, i), tid, type, src, size);
#endif
    }
    for (i = 0; i < cidy; i++) {
#ifdef __MPI__
	MPI_Request req;
	MPI_Isend(src, size, MPI_BYTE,
		  rec_tlin(cidx, i), type, MPI_COMM_WORLD, &req);
	MPI_Request_free(&req);
#elif defined(__AP__)
	l_asend(rec_tlin(cidx, i), tid, type, src, size);
#endif
    }
#endif
}

void
broad_recv_y(cid, type, src, size)
int cid, type;
char *src;
int size;
{
    int msg_size;
#ifdef __MPI__
    MPI_Status status;

    MPI_Recv(src, size, MPI_BYTE,
	     MPI_ANY_SOURCE, type,
	     MPI_COMM_WORLD, &status);
#elif defined(__AP__)
    l_arecv(ANY_CELL, tid, type);
    msg_size = getmsize();
    readmsg(src, msg_size);
#endif

#ifdef LOG_BROAD
    {
	int i;
	int sid;

#ifdef __MPI__
	MPI_Get_count(&status, MPI_BYTE, &msg_size);
	sid = status.MPI_SOURCE;
#elif defined(__AP__)
	sid = getmcid();
#endif
	i = (sid ^ cid);

	for (i <<= 1; i < NUM_PROC; i <<= 1) {
#ifdef __MPI__
	    MPI_Request req;
	    MPI_Isend(src, msg_size, MPI_BYTE,
		     cid ^ i, type, MPI_COMM_WORLD, &req);
	    MPI_Request_free(&req);
#elif defined(__AP__)
	    l_asend(cid ^ i, tid, type, src, msg_size);
#endif
	}
    }
#endif
}

/***/

void
broad_bsend_y(cid, type, src, size)
int cid, type;
char *src;
int size;
{
    int i;

#ifdef LOG_BROAD
    for (i = NUM_PROC_X; i < NUM_PROC; i <<= 1) {
#ifdef __MPI__
	MPI_Send(src, size, MPI_BYTE,
		 cid ^ i, type, MPI_COMM_WORLD);
#elif defined(__AP__)
	l_asend(cid ^ i, tid, type, src, size);
#endif
    }
#else /* SER_BROAD */
    int cidx, cidy;
    lin_trec(cid, cidx, cidy);
    for (i = cidy + 1; i < NUM_PROC_Y; i++) {
#ifdef __MPI__
	MPI_Send(src, size, MPI_BYTE,
		 rec_tlin(cidx, i), type, MPI_COMM_WORLD);
#elif defined(__AP__)
	l_asend(rec_tlin(cidx, i), tid, type, src, size);
#endif
    }
    for (i = 0; i < cidy; i++) {
#ifdef __MPI__
	MPI_Send(src, size, MPI_BYTE,
		 rec_tlin(cidx, i), type, MPI_COMM_WORLD);
#elif defined(__AP__)
	l_asend(rec_tlin(cidx, i), tid, type, src, size);
#endif
    }
#endif
}

void
broad_brecv_y(cid, type, src, size)
int cid, type;
char *src;
int size;
{
    int msg_size;
#ifdef __MPI__
    MPI_Status status;

    MPI_Recv(src, size, MPI_BYTE,
	     MPI_ANY_SOURCE, type,
	     MPI_COMM_WORLD, &status);
#elif defined(__AP__)
    l_arecv(ANY_CELL, tid, type);
    msg_size = getmsize();
    readmsg(src, msg_size);
#endif

#ifdef LOG_BROAD
    {
	int i;
	int sid;

#ifdef __MPI__
	MPI_Get_count(&status, MPI_BYTE, &msg_size);
	sid = status.MPI_SOURCE;
#elif defined(__AP__)
	sid = getmcid();
#endif
	i = (sid ^ cid);

	for (i <<= 1; i < NUM_PROC; i <<= 1) {
#ifdef __MPI__
	    MPI_Send(src, msg_size, MPI_BYTE,
		     cid ^ i, type, MPI_COMM_WORLD);
#elif defined(__AP__)
	    l_asend(cid ^ i, tid, type, src, msg_size);
#endif
	}
    }
#endif
}

/*
 *
 */

#ifndef COPY_RECV_MSG

char*
fbroad_recv_y(cid, type)
int cid, type;
{
    int msg_size;
#ifdef LOG_BROAD
    int i;
    int sid;
#endif
    char* recv_buf;
#ifdef __AP__
    recv_buf = l_arecv(ANY_CELL, tid, type);
#endif

#ifdef LOG_BROAD
    msg_size = getmsize();
#ifdef __AP__
    sid = getmcid();
#endif
    i = (sid ^ cid);

    for (i <<= 1; i < NUM_PROC; i <<= 1) {
#ifdef __AP__
	l_asend(cid ^ i, tid, type, src, msg_size);
#endif
    }
#endif
    return recv_buf;
}

#endif
