/*
 *  index-conversion functions for block-cyclic distribution
 */

#include "conf.h"
#include "dist.h"

/*
 * int procid_dot_x(i, NUM_DATA)
 * int toglobal_dot_x(cid, i, NUM_DATA)
 * int tolocal_dot_x(cid, i, NUM_DATA)
 *
 * int procid_dot_y(i, NUM_DATA)
 * int num_in_proc_dot_y(cid, NUM_DATA)
 * int toglobal_dot_y(cid, i, NUM_DATA)
 * int tolocal_dot_y(cid, i, NUM_DATA)
 *
 *     are all defined in 'lu.h'
 */

int
num_in_proc_dot_x(cid, num_data)
int cid, num_data;
{
    int num_block = (num_data + BLOCK_SIZE - 1) / BLOCK_SIZE;
    int num_a_proc;
    if (cid < num_block % NUM_PROC_X)
	num_a_proc = (num_block / NUM_PROC_X + 1) * BLOCK_SIZE;
    else
	num_a_proc = (num_block / NUM_PROC_X) * BLOCK_SIZE;
    if (cid == (num_block - 1) % NUM_PROC_X)
	num_a_proc -= num_block * BLOCK_SIZE - num_data;
    return num_a_proc;
}
