#ifndef __lu_h__
#define __lu_h__

/***  MESSAGE TYPES  ***/

/* gauss.c */

#define BROAD_PIV_CELL	200
#define BROAD_INV_PIV1	201
#define BROAD_PIV	202
#define BROAD_LOC_PIV1	203

#define BROAD_INV_PIV	100
#define BROAD_PIV_LAST	101

#define BROAD_ANS_B	204

/* pivot.c */

#define BROAD_PIV_1	205
#define BROAD_PIV_X	206

/* max2.c */

#define MAX_VALUE	102

/* sum.c */

#define X_DSUM		103
#define Y_DSUM		104

#define SKIP		7

/*
 *  Function Declarations
 */

/* in pivot.c */

double*
get_pivot1_x(/* int cid, int i */);

double*
get_pivot1_y(/* int cid, int i */);

/* in pivot8.c */

double*
get_pivot8_x(/* int cid, int iter, int j */);

double*
get_pivot8_y(/* int cid, int i */);

#ifdef __GNUC__

/* in 'gauss.c' */

void
solve_matrix(int cid, int size, dot_mat pA, double *global_x);

/* in 'max2.c' */

void
max_y(int cid, int *piv_i, double *local_max, double *local_piv);

void
max8_y(int cid, int *piv_i, double *local_max, double *local_piv);

/* in 'broad.c' */

void
broad_send_double(int cid, int type, double* src);

void
broad_recv_double(int cid, int type, double* src);

/* in 'broad_x.c' */

void
broad_send_x(int cid, int type, void* src, int size);

void
broad_recv_x(int cid, int type, void* src, int size);

void
broad_bsend_x(int cid, int type, void* src, int size);

void
broad_brecv_x(int cid, int type, void* src, int size);

char*
fbroad_recv_x(int cid, int type);

/* in 'broad_y.c' */

void
broad_send_int_y(int cid, int type, int* src);

void
broad_recv_int_y(int cid, int type, int* src);

void
broad_send_double_y(int cid, int type, double* src);

void
broad_recv_double_y(int cid, int type, double* src);

void
broad_bsend_y(int cid, int type, void* src, int size);

void
broad_brecv_y(int cid, int type, void* src, int size);

char*
fbroad_recv_y(int cid, int type);

/* in 'pivot8.c' */

void
p_pivot_8_y(int cid, int size, dot_mat pA,
	    int i, int st_j, double *pivt, double *py);
void
broad_piv(int cid, int size, int size_x, dot_mat pA,
	  int i, int st_j, double *piv1[]);

/* in 'pivot.c' */

void
p_pivot_y(int cid, int size, dot_mat pA, 
	  int i, int st_j, double *py);
void
broad_piv_1(int cid, int size, int size_x, dot_mat pA,
	    int i, int st_j, double* piv1[]);

/* in 'dot.c' */

int
num_in_proc_dot_x(int cid, int num_data);

/* in 'block.c' */

int
num_in_proc_block(int cid, int num_data);

int
tolocal_block(int cid, int i, int num_data);

#endif

#endif
