#ifdef __MPI__
#include <mpi.h>
#endif

#include "conf.h"
#include "lu.h"

/*
 *  Summing up 'double' numbers among processors along the
 *  Y-direction.
 *
 *  parameters:
 *	cid	a node ID
 *	src	'double' number (input)
 *	dest	'double' numner (output)
 */

#ifdef __AP__
void
dsum_y(cid, src, dest)
int cid;
double src;
double *dest;
{
    y_dsum(src, dest);
}
#endif

#ifdef __MPI__
void
dsum_y(cid, src, dest)
int cid;
double src;
double *dest;
{
    int		i;
    double	t, t1;
    double	sum = src;
    MPI_Status	status;

    for (i = NUM_PROC_X; i < NUM_PROC; i <<= 1) {
	t = sum;
	MPI_Send(&t, 1, MPI_DOUBLE,
		 cid ^ i, Y_DSUM,
		 MPI_COMM_WORLD);
	MPI_Recv(&t1, 1, MPI_DOUBLE,
		 cid ^ i, Y_DSUM,
		 MPI_COMM_WORLD, &status);
	sum += t1;
    }
    *dest = sum;
}
#endif
