*
*     main program
*
*     $Id: main_s.f,v 1.1 2000/06/22 07:27:46 tatebe Exp $
*

*
*     Copyright(C) 2000 Osamu Tatebe, all rights reserved, no warranty.
*
*     This software is a free software.  All rights of this software
*     belong to Osamu Tatebe.  You can redistribute this whole package
*     as it is if you do not modify and inform me by E-mail.
*

      PROGRAM SAMPLE
*
      INTEGER   MAX_GRID_LEVEL, MAX_M1, MAX_M2, MAX_M3, MAX_N
      INTEGER   NUM_DIAG

      PARAMETER (MAX_GRID_LEVEL = 5)

      PARAMETER (MAX_M1 = 2 ** MAX_GRID_LEVEL)
      PARAMETER (MAX_M2 = MAX_M1, MAX_M3 = MAX_M1)
      PARAMETER (MAX_N = (MAX_M1 + 2) * (MAX_M2 + 2) * (MAX_M2 + 2))
      PARAMETER (NUM_DIAG = 7)

      INTEGER   G_N, G_M1(MAX_GRID_LEVEL + 2), G_M2(MAX_GRID_LEVEL + 2)
      INTEGER   G_M3(MAX_GRID_LEVEL + 2)
      INTEGER   L_L(MAX_GRID_LEVEL + 2)
      REAL*8    A(NUM_DIAG, MAX_N * 8 / 7), B(MAX_N), X1(MAX_N)
*     Work Space for MGCG
      REAL*8    WS(4 * MAX_N + MAX_N * 8 / 7 + MAX_N * 30 / 7)
      SAVE      A, B, X1, WS

      REAL*8    EPS
      PARAMETER (EPS = 1.0D-11)

      INTEGER   PROB_NO
      INTEGER   LOG_M, M1, M2, M3, N
      INTEGER   G_LEV, GRIDS, NUM_C
      INTEGER   I, J, K
*
!$    INTEGER   OMP_GET_NUM_THREADS
*
      INTEGER   IER
      REAL*4    T0, T1, SECOND

*
*     Problem and problem size
*

      PROB_NO = 3
      LOG_M = 5

      IF (PROB_NO .EQ. 1 .OR. PROB_NO .EQ. 3) THEN
          M1 = 2 ** LOG_M - 1
      ELSE IF (PROB_NO .EQ. 2) THEN
          M1 = 2 ** LOG_M
      END IF
      M2 = M1
      M3 = M1

*
*     Parameters for MGCG
*

      GRIDS = 5
      NUM_C = 1

*
      N = M1 * M2 * M3

      WRITE (6, 1001) PROB_NO
 1001 FORMAT ('problem: ', I2)
      WRITE (6, 1002) N, M1, M2, M3
 1002 FORMAT ('global: n = ', I8, ' (', I4, ' x ', I4, ' x ', I4, ' )')
      WRITE (6, 1004) GRIDS
 1004 FORMAT ('grids = ', I3)

      CALL ASSERT(N .LE. MAX_N, 'main_s.f', 85)

*
*     For OpenMP
*

!$OMP PARALLEL
!$OMP SINGLE
!$    WRITE (*,*) '#threads = ', OMP_GET_NUM_THREADS()
!$OMP END SINGLE
!$OMP END PARALLEL

*
*     Set up a problem
*

      G_LEV = 1

      G_N = N
      G_M1(G_LEV) = M1
      G_M2(G_LEV) = M2
      G_M3(G_LEV) = M3

      L_L(G_LEV) = 0

*     WHILE (G_N > 0)
   10 IF (G_N .LE. 0) GO TO 50

          IF (PROB_NO .EQ. 1) THEN
*             /*  Dirichlet condition */
              CALL SETUP_PROB_DIRICHLET_S(G_M1(G_LEV), G_M2(G_LEV),
     $                                    G_M3(G_LEV),
     $                                    A(1, L_L(G_LEV) + 1))
          ELSE IF (PROB_NO .EQ. 3) THEN
*             /*  T-shape problem */
              CALL SETUP_PROB_T_SHAPE_S(G_M1(G_LEV), G_M2(G_LEV),
     $                                  G_M3(G_LEV),
     $                                  A(1, L_L(G_LEV) + 1))
          ELSE
              WRITE (6, 1005)
 1005         FORMAT ('no problem')
              GO TO 90
          END IF

*          write (*,*) G_LEV, ':'
*          do i = 1, G_N
*              write (6,9999) (A(J, L_L(G_LEV) + I), J=1,7)
* 9999         format (F8.0, F8.0, F8.0, F8.0, F8.0, F8.0, F8.0)
*          end do

          CALL REST_DIM(G_M1(G_LEV), G_M2(G_LEV), G_M3(G_LEV),
     $                  G_M1(G_LEV+1), G_M2(G_LEV+1), G_M3(G_LEV+1))

          G_LEV = G_LEV + 1

          L_L(G_LEV) = L_L(G_LEV - 1) + G_N
          G_N = G_M1(G_LEV) * G_M2(G_LEV) * G_M3(G_LEV)

      GO TO 10

   50 CONTINUE

      CALL ASSERT(GRIDS .LT. G_LEV, 'main_s.f', 148)

*
*     Source term
*

!$OMP PARALLEL DO
      DO I = 1, N
          B(I) = 100.0
      END DO

*
*     Initial Approximate
*

!$OMP PARALLEL DO PRIVATE(J, I)
      DO K = 2, M3+1
          DO J = 2, M2+1
              DO I = 2, M1+1
                  X1(I + (J - 1) * (M1 + 2)
     $                 + (K - 1) * (M1 + 2) * (M2 + 2)) = 0.0
              END DO
          END DO
      END DO

*
*     Solve
*

      I = 100

      T0 = SECOND()

      CALL MGCG(GRIDS, NUM_C, G_M1, G_M2, G_M3,
     $          A, B, X1, I, EPS,
     $          WS, IER)

      T1 = SECOND()
      WRITE(*,*) T1 - T0

   90 CONTINUE

      END
