*
*     Prolongation
*
*     $Id: prog_s.f,v 1.1 2000/06/22 07:27:46 tatebe Exp $
*

      SUBROUTINE PROLONG_INNER_S(MM1, MM2, MM3, X, M1, M2, M3, Y)
*
      INTEGER   MM1, MM2, MM3, M1, M2, M3
      REAL*8    X(0:MM1+1, 0:MM2+1, 0:MM3+1), Y(M1, M2, M3)
*
      INTEGER   I, J, K, I1, J1, K1

      IF (MM1 * MM2 * MM3 .EQ. 0) RETURN

*     /*  Inner points */

!$OMP PARALLEL DO PRIVATE(J, I, K1, J1, I1)
      DO K = 1, MM3
          K1 = 2 * K
          DO J = 1, MM2
              J1 = 2 * J
              DO I = 1, MM1
                  I1 = 2 * I
                  Y(I1, J1, K1) = X(I, J, K)
              END DO
          END DO
      END DO

!$OMP PARALLEL DO PRIVATE(J, I)
      DO K = 2, M3, 2
          DO J = 2, M2, 2
              DO I = 3, M1 - 1, 2
                  Y(I, J, K) = .5 * (Y(I - 1, J, K) + Y(I + 1, J, K))
              END DO
              IF (I .LE. M1) THEN
                  Y(I, J, K) = .5 * Y(I - 1, J, K)
              END IF
          END DO
      END DO

!$OMP PARALLEL DO PRIVATE(J, I)
      DO K = 2, M3, 2
          DO J = 3, M2 - 1, 2
              DO I = 2, M1
                  Y(I, J, K) = .5 * (Y(I, J - 1, K) + Y(I, J + 1, K))
              END DO
          END DO

          IF ((M2 / 2) * 2 .NE. M2) THEN
              J = M2
              DO I = 2, M1
                  Y(I, J, K) = .5 * Y(I, J - 1, K)
              END DO
          END IF
      END DO

!$OMP PARALLEL DO PRIVATE(J, I)
      DO K = 3, M3 - 1, 2
          DO J = 2, M2
              DO I = 2, M1
                  Y(I, J, K) = .5 * (Y(I, J, K - 1) + Y(I, J, K + 1))
              END DO
          END DO
      END DO

      IF ((M3 / 2) * 2 .NE. M3) THEN
          K = M3
          DO J = 2, M2
              DO I = 2, M1
                  Y(I, J, K) = .5 * Y(I, J, K - 1)
              END DO
          END DO
      END IF

      RETURN
      END

*
*
*

      SUBROUTINE PROLONG_BOUND_S(M1, M2, M3, Y)
*
      INTEGER   M1, M2, M3
      REAL*8    Y(M1, M2, M3)
*
      INTEGER   I, J, K

      K = 1
!$OMP PARALLEL DO PRIVATE(I)
      DO J = 2, M2
          DO I = 2, M1
              Y(I, J, K) = .5 * Y(I, J, K + 1)
          END DO
      END DO

      I = 1
!$OMP PARALLEL DO PRIVATE(J)
      DO K = 1, M3
          DO J = 2, M2
              Y(I, J, K) = .5 * Y(I + 1, J, K)
          END DO
      END DO

*     /*  If I am the leftmost and bottom processor, update data */
*     /*  at left and bottom corner. */
      J = 1
!$OMP PARALLEL DO PRIVATE(I)
      DO K = 1, M3
          DO I = 1, M1
              Y(I, J, K) = .5 * Y(I, J + 1, K)
          END DO
      END DO

      RETURN
      END

*
*
*

      SUBROUTINE PROLONG_S(MM1, MM2, MM3, X, M1, M2, M3, Y)
*
      INTEGER   MM1, MM2, MM3, M1, M2, M3
      REAL*8    X(MM1 + 2, MM2 + 2, MM3 + 2), Y(M1 * M2 * M3)

      CALL PROLONG_INNER_S(MM1, MM2, MM3, X, M1, M2, M3, Y)

      CALL PROLONG_BOUND_S(M1, M2, M3, Y)

      RETURN
      END
