*
*     Serial Red-Black Gauss-Seidel method
*
*     $Id: rb_s.f,v 1.1 2000/06/22 07:27:46 tatebe Exp $
*

      SUBROUTINE RB_GS_S(M1, M2, M3, A, INV_A, B, X, ITER)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2, M3
      REAL*8    A(NUM_DIAG, M1 * M2 * M3), INV_A(M1 * M2 * M3)
      REAL*8    B(M1 * M2 * M3)
      REAL*8    X(M1 + 2, M2 + 2, M3 + 2)
      INTEGER   ITER
*
      INTEGER   I

      DO I = 1, ITER
          CALL R_GS_S(M1, M2, M3, A, INV_A, B, X)
          CALL B_GS_S(M1, M2, M3, A, INV_A, B, X)
      END DO

      RETURN
      END


      SUBROUTINE BR_GS_S(M1, M2, M3, A, INV_A, B, X, ITER)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2, M3
      REAL*8    A(NUM_DIAG, M1 * M2 * M3), INV_A(M1 * M2 * M3)
      REAL*8    B(M1 * M2 * M3)
      REAL*8    X(M1 + 2, M2 + 2, M3 + 2)
      INTEGER   ITER
*
      INTEGER   I

      DO I = 1, ITER
          CALL B_GS_S(M1, M2, M3, A, INV_A, B, X)
          CALL R_GS_S(M1, M2, M3, A, INV_A, B, X)
      END DO

      RETURN
      END

*
*     Update only Red points
*

      SUBROUTINE R_GS_2D_INNER_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1, M2), INV_A(M1, M2)
      REAL*8    B(M1, M2), X(0:M1+1, 0:M2+1, 0:2)
*
      INTEGER   I, J, K

*!$OMP PARALLEL PRIVATE(I, J, K) FIRSTPRIVATE(M1, M2)
      K = 1
!$OMP DO
      DO J = 2, M2 - 2, 2
          DO I = 2, M1 - 1, 2
              X(I, J, K) =
     $            (B(I, J) -
     $             A(1, I, J) * X(I, J, K - 1) -
     $             A(2, I, J) * X(I, J - 1, K) -
     $             A(3, I, J) * X(I - 1, J, K) -
     $             A(5, I, J) * X(I + 1, J, K) -
     $             A(6, I, J) * X(I, J + 1, K) -
     $             A(7, I, J) * X(I, J, K + 1)) *
     $            INV_A(I, J)
          END DO

          DO I = 3, M1 - 1, 2
              X(I, J+1, K) =
     $            (B(I, J+1) -
     $             A(1, I, J+1) * X(I, J+1, K - 1) -
     $             A(2, I, J+1) * X(I, J+1 - 1, K) -
     $             A(3, I, J+1) * X(I - 1, J+1, K) -
     $             A(5, I, J+1) * X(I + 1, J+1, K) -
     $             A(6, I, J+1) * X(I, J+1 + 1, K) -
     $             A(7, I, J+1) * X(I, J+1, K + 1)) *
     $            INV_A(I, J+1)
          END DO
      END DO
!$OMP END DO NOWAIT

      IF ((M2 / 2) * 2 .NE. M2) THEN
          J = M2 - 1
!$OMP DO
          DO I = 2, M1 - 1, 2
              X(I, J, K) =
     $            (B(I, J) -
     $             A(1, I, J) * X(I, J, K - 1) -
     $             A(2, I, J) * X(I, J - 1, K) -
     $             A(3, I, J) * X(I - 1, J, K) -
     $             A(5, I, J) * X(I + 1, J, K) -
     $             A(6, I, J) * X(I, J + 1, K) -
     $             A(7, I, J) * X(I, J, K + 1)) *
     $            INV_A(I, J)
          END DO
      END IF
*!$OMP END PARALLEL

      RETURN
      END

*
*
*

      SUBROUTINE R_GS_2D_BOUND_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1, M2), INV_A(M1, M2)
      REAL*8    B(M1, M2), X(0:M1+1, 0:M2+1, 0:2)
*
      INTEGER   I, J, K, IST, JST

!$OMP SECTIONS PRIVATE(I, J, K, IST, JST)
!$OMP&         FIRSTPRIVATE(M1, M2)
!$OMP SECTION
      K = 1
      J = 1
      DO I = 1, M1, 2
          X(I, J, K) =
     $        (B(I, J) -
     $         A(1, I, J) * X(I, J, K - 1) -
     $         A(2, I, J) * X(I, J - 1, K) -
     $         A(3, I, J) * X(I - 1, J, K) -
     $         A(5, I, J) * X(I + 1, J, K) -
     $         A(6, I, J) * X(I, J + 1, K) -
     $         A(7, I, J) * X(I, J, K + 1)) *
     $        INV_A(I, J)
      END DO

!$OMP SECTION
      IF ((M2 / 2) * 2 .EQ. M2) THEN
          IST = 2
      ELSE
          IST = 1
      END IF
      J = M2
      DO I = IST, M1, 2
          X(I, J, K) =
     $        (B(I, J) -
     $         A(1, I, J) * X(I, J, K - 1) -
     $         A(2, I, J) * X(I, J - 1, K) -
     $         A(3, I, J) * X(I - 1, J, K) -
     $         A(5, I, J) * X(I + 1, J, K) -
     $         A(6, I, J) * X(I, J + 1, K) -
     $         A(7, I, J) * X(I, J, K + 1)) *
     $        INV_A(I, J)
      END DO

!$OMP SECTION
      I = 1
      DO J = 3, M2 - 1, 2
          X(I, J, K) =
     $        (B(I, J) -
     $         A(1, I, J) * X(I, J, K - 1) -
     $         A(2, I, J) * X(I, J - 1, K) -
     $         A(3, I, J) * X(I - 1, J, K) -
     $         A(5, I, J) * X(I + 1, J, K) -
     $         A(6, I, J) * X(I, J + 1, K) -
     $         A(7, I, J) * X(I, J, K + 1)) *
     $        INV_A(I, J)
      END DO

!$OMP SECTION
      IF ((M1 / 2) * 2 .EQ. M1) THEN
          JST = 2
      ELSE
          JST = 3
      END IF
      I = M1
      DO J = JST, M2 - 1, 2
          X(I, J, K) =
     $        (B(I, J) -
     $         A(1, I, J) * X(I, J, K - 1) -
     $         A(2, I, J) * X(I, J - 1, K) -
     $         A(3, I, J) * X(I - 1, J, K) -
     $         A(5, I, J) * X(I + 1, J, K) -
     $         A(6, I, J) * X(I, J + 1, K) -
     $         A(7, I, J) * X(I, J, K + 1)) *
     $        INV_A(I, J)
      END DO
!$OMP END SECTIONS

      RETURN
      END

*
*
*

*
*
*

      SUBROUTINE R_GS_2D_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1 * M2), INV_A(M1 * M2), B(M1 * M2)
      REAL*8    X(M1 + 2, M2 + 2, 3)

      IF (M1 * M2 .EQ. 0) GO TO 10

      CALL R_GS_2D_INNER_S(M1, M2, A, INV_A, B, X)

      CALL R_GS_2D_BOUND_S(M1, M2, A, INV_A, B, X)

   10 CONTINUE

      RETURN
      END

*
*
*     Update only Black points
*
*

      SUBROUTINE B_GS_2D_INNER_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1, M2), INV_A(M1, M2)
      REAL*8    B(M1, M2), X(0:M1+1, 0:M2+1, 0:2)
*
      INTEGER   I, J, K

*!$OMP PARALLEL PRIVATE(I, J, K) FIRSTPRIVATE(M1, M2)
      K = 1
!$OMP DO
      DO J = 2, M2 - 2, 2
          DO I = 3, M1 - 1, 2
              X(I, J, K) =
     $            (B(I, J) -
     $             A(1, I, J) * X(I, J, K - 1) -
     $             A(2, I, J) * X(I, J - 1, K) -
     $             A(3, I, J) * X(I - 1, J, K) -
     $             A(5, I, J) * X(I + 1, J, K) -
     $             A(6, I, J) * X(I, J + 1, K) -
     $             A(7, I, J) * X(I, J, K + 1)) *
     $            INV_A(I, J)
          END DO

          DO I = 2, M1 - 1, 2
              X(I, J+1, K) =
     $            (B(I, J+1) -
     $             A(1, I, J+1) * X(I, J+1, K - 1) -
     $             A(2, I, J+1) * X(I, J+1 - 1, K) -
     $             A(3, I, J+1) * X(I - 1, J+1, K) -
     $             A(5, I, J+1) * X(I + 1, J+1, K) -
     $             A(6, I, J+1) * X(I, J+1 + 1, K) -
     $             A(7, I, J+1) * X(I, J+1, K + 1)) *
     $            INV_A(I, J+1)
          END DO
      END DO
!$OMP END DO NOWAIT

      IF ((M2 / 2) * 2 .NE. M2) THEN
          J = M2 - 1
!$OMP DO
          DO I = 3, M1 - 1, 2
              X(I, J, K) =
     $            (B(I, J) -
     $             A(1, I, J) * X(I, J, K - 1) -
     $             A(2, I, J) * X(I, J - 1, K) -
     $             A(3, I, J) * X(I - 1, J, K) -
     $             A(5, I, J) * X(I + 1, J, K) -
     $             A(6, I, J) * X(I, J + 1, K) -
     $             A(7, I, J) * X(I, J, K + 1)) *
     $            INV_A(I, J)
          END DO
      END IF
*!$OMP END PARALLEL

      RETURN
      END

*
*
*

      SUBROUTINE B_GS_2D_BOUND_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1, M2), INV_A(M1, M2)
      REAL*8    B(M1, M2), X(0:M1+1, 0:M2+1, 0:2)
*
      INTEGER   I, J, K, IST, JST

!$OMP SECTIONS PRIVATE (I, J, K, IST, JST)
!$OMP&         FIRSTPRIVATE(M1, M2)
!$OMP SECTION
      K = 1
      J = 1
      DO I = 2, M1, 2
          X(I, J, K) =
     $        (B(I, J) -
     $         A(1, I, J) * X(I, J, K - 1) -
     $         A(2, I, J) * X(I, J - 1, K) -
     $         A(3, I, J) * X(I - 1, J, K) -
     $         A(5, I, J) * X(I + 1, J, K) -
     $         A(6, I, J) * X(I, J + 1, K) -
     $         A(7, I, J) * X(I, J, K + 1)) *
     $        INV_A(I, J)
      END DO

!$OMP SECTION
      IF ((M2 / 2) * 2 .EQ. M2) THEN
          IST = 1
      ELSE
          IST = 2
      END IF
      J = M2
      DO I = IST, M1, 2
          X(I, J, K) =
     $        (B(I, J) -
     $         A(1, I, J) * X(I, J, K - 1) -
     $         A(2, I, J) * X(I, J - 1, K) -
     $         A(3, I, J) * X(I - 1, J, K) -
     $         A(5, I, J) * X(I + 1, J, K) -
     $         A(6, I, J) * X(I, J + 1, K) -
     $         A(7, I, J) * X(I, J, K + 1)) *
     $        INV_A(I, J)
      END DO

!$OMP SECTION
      I = 1
      DO J = 2, M2 - 1, 2
          X(I, J, K) =
     $        (B(I, J) -
     $         A(1, I, J) * X(I, J, K - 1) -
     $         A(2, I, J) * X(I, J - 1, K) -
     $         A(3, I, J) * X(I - 1, J, K) -
     $         A(5, I, J) * X(I + 1, J, K) -
     $         A(6, I, J) * X(I, J + 1, K) -
     $         A(7, I, J) * X(I, J, K + 1)) *
     $        INV_A(I, J)
      END DO

!$OMP SECTION
      IF ((M1 / 2) * 2 .EQ. M1) THEN
          JST = 3
      ELSE
          JST = 2
      END IF
      I = M1
      DO J = JST, M2 - 1, 2
          X(I, J, K) =
     $        (B(I, J) -
     $         A(1, I, J) * X(I, J, K - 1) -
     $         A(2, I, J) * X(I, J - 1, K) -
     $         A(3, I, J) * X(I - 1, J, K) -
     $         A(5, I, J) * X(I + 1, J, K) -
     $         A(6, I, J) * X(I, J + 1, K) -
     $         A(7, I, J) * X(I, J, K + 1)) *
     $        INV_A(I, J)
      END DO
!$OMP END SECTIONS

      RETURN
      END

*
*
*

*
*
*

      SUBROUTINE B_GS_2D_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1 * M2), INV_A(M1 * M2), B(M1 * M2)
      REAL*8    X(M1 + 2, M2 + 2, 3)

      IF (M1 * M2 .EQ. 0) GO TO 10

      CALL B_GS_2D_INNER_S(M1, M2, A, INV_A, B, X)

      CALL B_GS_2D_BOUND_S(M1, M2, A, INV_A, B, X)

   10 CONTINUE

      RETURN
      END

*
*
*

      SUBROUTINE R_GS_S(M1, M2, M3, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2, M3
      REAL*8    A(NUM_DIAG, M1, M2, M3), INV_A(M1, M2, M3)
      REAL*8    B(M1, M2, M3), X(0:M1+1, 0:M2+1, 0:M3+1)
*
      INTEGER   I

*      DO I = 1, M3 - 1, 2
*          CALL R_GS_2D_S(M1, M2, A(1, 1, 1, I), INV_A(1, 1, I),
*     $                   B(1, 1, I), X(0, 0, I-1))
*          CALL B_GS_2D_S(M1, M2, A(1, 1, 1, I+1), INV_A(1, 1, I+1),
*     $                   B(1, 1, I+1), X(0, 0, I-1+1))
*      END DO
*
*      IF ((M3 / 2) * 2 .NE. M3) THEN
*          I = M3
*          CALL R_GS_2D_S(M1, M2, A(1, 1, 1, I), INV_A(1, 1, I),
*     $                   B(1, 1, I), X(0, 0, I-1))
*      END IF

!$OMP PARALLEL
      DO I = 1, M3 - 1, 2
          CALL R_GS_2D_INNER_S(M1, M2, A(1, 1, 1, I),
     $             INV_A(1, 1, I), B(1, 1, I), X(0, 0, I-1))
          CALL B_GS_2D_INNER_S(M1, M2, A(1, 1, 1, I+1),
     $             INV_A(1, 1, I+1), B(1, 1, I+1), X(0, 0, I-1+1))
      END DO

      IF ((M3 / 2) * 2 .NE. M3) THEN
          I = M3
          CALL R_GS_2D_INNER_S(M1, M2, A(1, 1, 1, I),
     $             INV_A(1, 1, I), B(1, 1, I), X(0, 0, I-1))
      END IF
!$OMP END PARALLEL

      DO I = 1, M3 - 1, 2
          CALL R_GS_2D_BOUND_S(M1, M2, A(1, 1, 1, I),
     $             INV_A(1, 1, I), B(1, 1, I), X(0, 0, I-1))
          CALL B_GS_2D_BOUND_S(M1, M2, A(1, 1, 1, I+1),
     $             INV_A(1, 1, I+1), B(1, 1, I+1), X(0, 0, I-1+1))
      END DO

      IF ((M3 / 2) * 2 .NE. M3) THEN
          I = M3
          CALL R_GS_2D_BOUND_S(M1, M2, A(1, 1, 1, I),
     $             INV_A(1, 1, I), B(1, 1, I), X(0, 0, I-1))
      END IF

      RETURN
      END

*
*
*

      SUBROUTINE B_GS_S(M1, M2, M3, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2, M3
      REAL*8    A(NUM_DIAG, M1, M2, M3), INV_A(M1, M2, M3)
      REAL*8    B(M1, M2, M3), X(0:M1+1, 0:M2+1, 0:M3+1)
*
      INTEGER   I

*      DO I = 1, M3 - 1, 2
*          CALL B_GS_2D_S(M1, M2, A(1, 1, 1, I), INV_A(1, 1, I),
*     $                   B(1, 1, I), X(0, 0, I-1))
*          CALL R_GS_2D_S(M1, M2, A(1, 1, 1, I+1), INV_A(1, 1, I+1),
*     $                   B(1, 1, I+1), X(0, 0, I-1+1))
*      END DO
*
*      IF ((M3 / 2) * 2 .NE. M3) THEN
*          I = M3
*          CALL B_GS_2D_S(M1, M2, A(1, 1, 1, I), INV_A(1, 1, I),
*     $                   B(1, 1, I), X(0, 0, I-1))
*      END IF

!$OMP PARALLEL
      DO I = 1, M3 - 1, 2
          CALL B_GS_2D_INNER_S(M1, M2, A(1, 1, 1, I),
     $             INV_A(1, 1, I), B(1, 1, I), X(0, 0, I-1))
          CALL R_GS_2D_INNER_S(M1, M2, A(1, 1, 1, I+1),
     $             INV_A(1, 1, I+1), B(1, 1, I+1), X(0, 0, I-1+1))
      END DO

      IF ((M3 / 2) * 2 .NE. M3) THEN
          I = M3
          CALL B_GS_2D_INNER_S(M1, M2, A(1, 1, 1, I),
     $             INV_A(1, 1, I), B(1, 1, I), X(0, 0, I-1))
      END IF
!$OMP END PARALLEL

      DO I = 1, M3 - 1, 2
          CALL B_GS_2D_BOUND_S(M1, M2, A(1, 1, 1, I),
     $             INV_A(1, 1, I), B(1, 1, I), X(0, 0, I-1))
          CALL R_GS_2D_BOUND_S(M1, M2, A(1, 1, 1, I+1),
     $             INV_A(1, 1, I+1), B(1, 1, I+1), X(0, 0, I-1+1))
      END DO

      IF ((M3 / 2) * 2 .NE. M3) THEN
          I = M3
          CALL B_GS_2D_BOUND_S(M1, M2, A(1, 1, 1, I),
     $             INV_A(1, 1, I), B(1, 1, I), X(0, 0, I-1))
      END IF

      RETURN
      END
