*     /*****  r = b - A x0, return sqrt(r, r) *****/
*
*     $Id: res_s.f,v 1.1 2000/06/22 07:27:46 tatebe Exp $
*

*
*     Compute only inner points
*

      SUBROUTINE RES_VEC_NORM_INNER_S(M1, M2, M3, B, A1, X, R, NORM)
*
      INTEGER   M1, M2, M3
      REAL*8    B(M1, M2, M3), A1(7, M1, M2, M3)
      REAL*8    X(0:M1+1, 0:M2+1, 0:M3+1), R(M1, M2, M3), NORM
*
      INTEGER   I, J, K
      REAL*8    TR

!$OMP PARALLEL DO PRIVATE(J, I, TR) REDUCTION(+:NORM)
!$OMP&            FIRSTPRIVATE(M1, M2, M3)
      DO K = 1, M3
          DO J = 1, M2
              DO I = 1, M1
                  TR = B(I, J, K) -
     $                (A1(1, I, J, K) * X(I, J, K - 1) +
     $                 A1(2, I, J, K) * X(I, J - 1, K) +
     $                 A1(3, I, J, K) * X(I - 1, J, K) +
     $                 A1(4, I, J, K) * X(I, J, K) +
     $                 A1(5, I, J, K) * X(I + 1, J, K) +
     $                 A1(6, I, J, K) * X(I, J + 1, K) +
     $                 A1(7, I, J, K) * X(I, J, K + 1))
                  R(I, J, K) = TR
                  NORM = NORM + TR * TR
              END DO
          END DO
      END DO

      RETURN
      END

**
**     Compute only boundary points
**
*
*      SUBROUTINE RES_VEC_NORM_BOUND_S(M1, M2, B, A1, X, R, NORM)
**
*      INCLUDE 'paraf.h'
**
*      INTEGER   M1, M2
*      REAL*8    B(M1, M2), A1(NUM_DIAG, M1, M2)
*      REAL*8    X(0:M1+1, 0:M2+1), R(M1, M2), NORM
**
*      INTEGER   I, J
*      REAL*8    TR
*
*      J = 1
*      DO I = 1, M1
*          TR = B(I, J) -
*     $        (A1(1, I, J) * X(I, J - 1) +
*     $         A1(2, I, J) * X(I - 1, J) +
*     $         A1(3, I, J) * X(I, J) +
*     $         A1(4, I, J) * X(I + 1, J) +
*     $         A1(5, I, J) * X(I, J + 1))
*          R(I, J) = TR
*          NORM = NORM + TR * TR
*      END DO
*
*      DO J = 2, M2 - 1
*          I = 1
*          TR = B(I, J) -
*     $        (A1(1, I, J) * X(I, J - 1) +
*     $         A1(2, I, J) * X(I - 1, J) +
*     $         A1(3, I, J) * X(I, J) +
*     $         A1(4, I, J) * X(I + 1, J) +
*     $         A1(5, I, J) * X(I, J + 1))
*          R(I, J) = TR
*          NORM = NORM + TR * TR
*
*          I = M1
*          TR = B(I, J) -
*     $        (A1(1, I, J) * X(I, J - 1) +
*     $         A1(2, I, J) * X(I - 1, J) +
*     $         A1(3, I, J) * X(I, J) +
*     $         A1(4, I, J) * X(I + 1, J) +
*     $         A1(5, I, J) * X(I, J + 1))
*          R(I, J) = TR
*          NORM = NORM + TR * TR
*      END DO
*
*      J = M2
*      DO I = 1, M1
*          TR = B(I, J) -
*     $        (A1(1, I, J) * X(I, J - 1) +
*     $         A1(2, I, J) * X(I - 1, J) +
*     $         A1(3, I, J) * X(I, J) +
*     $         A1(4, I, J) * X(I + 1, J) +
*     $         A1(5, I, J) * X(I, J + 1))
*          R(I, J) = TR
*          NORM = NORM + TR * TR
*      END DO
*
*      RETURN
*      END
*
*
*
*

      SUBROUTINE RES_VEC_NORM_S(M1, M2, M3, B, A1, X,
     $                          R, NORM)
*
      INTEGER   M1, M2, M3
      REAL*8    B(M1 * M2 * M3), A1(7, M1 * M2 * M3)
      REAL*8    X(M1+2, M2+2, M3+2)
      REAL*8    R(M1 * M2 * M3), NORM

      IF (M1 * M2 * M3 .EQ. 0) GO TO 10

      NORM = 0.0

      CALL RES_VEC_NORM_INNER_S(M1, M2, M3, B, A1, X, R, NORM)

*      CALL RES_VEC_NORM_BOUND_S(M1, M2, M3, B, A1, X, R, NORM)

      NORM = SQRT(NORM)

   10 CONTINUE

      RETURN
      END
