*
*     Restriction in 3 dimensions
*
*     $Id: rest_s.f,v 1.1 2000/06/22 07:27:46 tatebe Exp $
*

      SUBROUTINE REST_DIM(M1, M2, M3, MM1, MM2, MM3)
*
      INTEGER   M1, M2, M3, MM1, MM2, MM3

      MM1 = M1 / 2
      MM2 = M2 / 2
      MM3 = M3 / 2

      RETURN
      END


*
*     Restriction
*

      SUBROUTINE REST_INNER_S(M1, M2, M3, X, MM1, MM2, MM3, Y)
*
      INTEGER   M1, M2, M3, MM1, MM2, MM3
      REAL*8    X(M1, M2, M3), Y(MM1, MM2, MM3)
*
      REAL*8    INV_64
      PARAMETER (INV_64 = 1.0 / 64)
*
      INTEGER   I, J, K, I1, J1, K1

*     /*  Inner points */

!$OMP PARALLEL DO PRIVATE (J, I, K1, J1, I1)
!$OMP&            FIRSTPRIVATE(MM3, MM2, MM1)
      DO K = 1, MM3
          K1 = 2 * K
          DO J = 1, MM2
              J1 = 2 * J
              DO I = 1, MM1
                  I1 = 2 * I
                  Y(I, J, K) =
     $                (8.0 * X(I1, J1, K1) +
     $                 4.0 * (X(I1-1, J1, K1) + X(I1, J1-1, K1) +
     $                        X(I1, J1, K1-1) + X(I1+1, J1, K1) +
     $                        X(I1, J1+1, K1) + X(I1, J1, K1+1)) +
     $                 2.0 * (X(I1-1, J1-1, K1) + X(I1-1, J1+1, K1) +
     $                        X(I1-1, J1, K1-1) + X(I1-1, J1, K1+1) +
     $                        X(I1+1, J1-1, K1) + X(I1+1, J1+1, K1) +
     $                        X(I1+1, J1, K1-1) + X(I1+1, J1, K1+1) +
     $                        X(I1, J1-1, K1-1) + X(I1, J1-1, K1+1) +
     $                        X(I1, J1+1, K1-1) + X(I1, J1+1, K1+1)) +
     $                 X(I1-1, J1-1, K1-1) + X(I1-1, J1-1, K1+1) +
     $                 X(I1-1, J1+1, K1-1) + X(I1-1, J1+1, K1+1) +
     $                 X(I1+1, J1-1, K1-1) + X(I1+1, J1-1, K1+1) +
     $                 X(I1+1, J1+1, K1-1) + X(I1+1, J1+1, K1+1))
     $                * INV_64
              END DO
          END DO
      END DO

      RETURN
      END

**
**
*
*      SUBROUTINE REST_BOUND_S(M1, M2, X, MM1, MM2, Y)
**
*      INTEGER   M1, M2, MM1, MM2
*      REAL*8    X(M1 * M2), Y(MM1 * MM2)
**
*      REAL*8    INV_16
*      PARAMETER (INV_16 = 1.0 / 16)
**
*      INTEGER   I, I1
*      INTEGER   M4, N, NN
*
*      M4 = 2 * M1
*      N = M1 * M2
*      NN = MM1 * MM2
*
**     /*  If M1 is even  */
*
*      IF ((M1 / 2) * 2 .EQ. M1) THEN
*          I1 = MM1
*          DO I = M4, N - M1, M4
*              Y(I1) = (4.0 * X(I) +
*     $                 2.0 * (X(I - M1) + X(I - 1) +
*     $                        X(I + M1)) +
*     $                 X(I - M1 - 1) + X(I + M1 - 1)) * INV_16
*              I1 = I1 + MM1
*          END DO
*      END IF
*
**     /*  IF M2 is even  */
*
*      IF ((M2 / 2) * 2 .EQ. M2) THEN
*          I1 = NN - MM1 + 1
*          DO I = N - M1 + 2, N - 1, 2
*              Y(I1) = (4.0 * X(I) +
*     $                 2.0 * (X(I - M1) + X(I - 1) +
*     $                        X(I + 1)) +
*     $                 X(I - M1 - 1) + X(I - M1 + 1)) * INV_16
*              I1 = I1 + 1
*          END DO
*
*          IF (I .LE. N) THEN
*              Y(I1) = (4.0 * X(I) +
*     $                 2.0 * (X(I - M1) + X(I - 1)) +
*     $                 X(I - M1 - 1)) * INV_16
*          END IF
*      END IF
*
*      RETURN
*      END
*
*
*

*
*
*

      SUBROUTINE RESTRICT_S(M1, M2, M3, X, MM1, MM2, MM3, Y)
*
      INTEGER   M1, M2, M3, MM1, MM2, MM3
      REAL*8    X(M1 * M2 * M3), Y(MM1 * MM2 * MM3)
*
      CALL REST_INNER_S(M1, M2, M3, X, MM1, MM2, MM3, Y)

*      CALL REST_BOUND_S(M1, M2, M3, X, MM1, MM2, MM3, Y)

      RETURN
      END
