*     $Id: setup_prob3_s.f,v 1.1 2000/06/22 07:27:46 tatebe Exp $

*
*     3-Dimansional Poisson Problem with Dirichlet Condition
*
*     Diffusion factor has a discontinuity with 'T-shape'.
*
*     G_M1, G_M2 and G_M3 are assumed to be same and power of 2 minus 1.
*

*
*     Calculate diffusion factor
*
*     1 <= G_I <= G_M1 + 1
*     1 <= G_J <= G_M2 + 1
*     1 <= G_K <= G_M3 + 1
*

      DOUBLE PRECISION
     $    FUNCTION COEFF_T_SHAPE_S(G_M1, G_M2, G_M3, G_I, G_J, G_K)
*
      INTEGER G_M1, G_M2, G_M3, G_I, G_J, G_K
*
      DOUBLE PRECISION K1, K2
      PARAMETER (K1 = 1.0, K2 = 1000.0)
*
      INTEGER T_G_I
      INTEGER X(7), Y(7), Z(7)
      INTEGER I

      DO I = 1, 7
          X(I) = (G_M1 * I + 7) / 8
          Y(I) = (G_M2 * I + 7) / 8
          Z(I) = (G_M3 * I + 7) / 8
      END DO

*     Symmetry in X-axis

      IF (G_I .GT. X(4)) THEN
          T_G_I = 2 * X(4) - G_I + 1
      ELSE
          T_G_I = G_I
      END IF
*

      IF (G_K .LE. Y(2) .OR. G_K .GT. Y(4)) THEN
          COEFF_T_SHAPE_S = K1
      ELSE IF (G_J .LE. Y(1) .OR. G_J .GT. Y(7)) THEN
          COEFF_T_SHAPE_S = K1
      ELSE IF (G_J .GT. Y(1) .AND. T_G_I .LE. X(1)) THEN
          COEFF_T_SHAPE_S = K1
      ELSE IF (G_J .GT. Y(3) .AND. T_G_I .LE. X(3)) THEN
          COEFF_T_SHAPE_S = K1
      ELSE
          COEFF_T_SHAPE_S = K2
      END IF

      RETURN
      END

*
*
*

      DOUBLE PRECISION
     $    FUNCTION COEFF_T_SHAPE(G_M1, G_M2, G_M3, G_I, G_J, G_K)
*
      INTEGER G_M1, G_M2, G_M3, G_I, G_J, G_K
*
      INTEGER B_X, B_Y, B_Z
      DOUBLE PRECISION COEFF_T_SHAPE_S
      DOUBLE PRECISION COEFF
      INTEGER I, J, K

      IF (G_M1 .GT. 4 .OR. G_M2 .GT. 4 .OR. G_M3 .GT. 4) THEN

          COEFF_T_SHAPE = COEFF_T_SHAPE_S(G_M1, G_M2, G_M3,
     $                                    G_I, G_J, G_K)

*     SPECIAL CARE: SMALL SIZE

      ELSE

*     G_M1, G_M2 and G_M3 are assumed to be 1 or 3.

          B_X = 8 / (G_M1 + 1)
          B_Y = 8 / (G_M2 + 1)
          B_Z = 8 / (G_M3 + 1)

          COEFF = 0.0
          DO I = 1, B_X
              DO J = 1, B_Y
                  DO K = 1, B_Z
                      COEFF = COEFF
     $                     + COEFF_T_SHAPE_S(7, 7, 7,
     $                                       (G_I - 1) * B_X + I, 
     $                                       (G_J - 1) * B_Y + J,
     $                                       (G_K - 1) * B_Z + K)
                  END DO
              END DO
          END DO

          COEFF_T_SHAPE = COEFF / B_X / B_Y / B_Z
      END IF

      RETURN
      END

*
*
*

      SUBROUTINE SETUP_PROB_T_SHAPE_S(G_M1, G_M2, G_M3, A)
*
      INTEGER   NUM_DIAG
      PARAMETER (NUM_DIAG = 7)
*
      INTEGER   G_M1, G_M2, G_M3
      REAL*8    A(NUM_DIAG, G_M1, G_M2, G_M3)
*
      DOUBLE PRECISION COEFF_T_SHAPE
*
      INTEGER   I, J, K
      REAL*8    COEFF, INV_H

!$OMP PARALLEL PRIVATE(I, J, K, COEFF, INV_H)
!$OMP&         FIRSTPRIVATE(G_M1, G_M2, G_M3)

      INV_H = (G_M1 + 1.0) * (G_M1 + 1.0)

*     Diagonal Elements

!$OMP DO
      DO K = 1, G_M3
          DO J = 1, G_M2
              DO I = 1, G_M1
                  COEFF = COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J + 1, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I + 1, J, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I + 1, J + 1, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J, K + 1)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J + 1, K + 1)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I + 1, J, K + 1)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I+1, J+1, K+1)
                  A(4, I, J, K) = .75 * COEFF * INV_H
              END DO
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO K = 1, G_M3
          DO J = 1, G_M2
              A(3, 1, J, K) = 0

              DO I = 2, G_M1
                  COEFF = COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J + 1, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J, K + 1)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J + 1, K + 1)
                  A(3, I, J, K) = -.25 * COEFF * INV_H
                  A(5, I - 1, J, K) = -.25 * COEFF * INV_H
              END DO

              A(5, G_M1, J, K) = 0
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO K = 1, G_M3
          DO I = 1, G_M1
              A(2, I, 1, K) = 0
          END DO

          DO I = 1, G_M1
              A(6, I, G_M2, K) = 0
          END DO

          DO J = 2, G_M2
              DO I = 1, G_M1
                  COEFF = COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I + 1, J, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J, K + 1)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I + 1, J, K + 1)
                  A(2, I, J, K) = -.25 * COEFF * INV_H
                  A(6, I, J - 1, K) = -.25 * COEFF * INV_H
              END DO
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO J = 1, G_M2
          DO I = 1, G_M1
              A(1, I, J, 1) = 0
          END DO
      END DO
!$OMP END DO NOWAIT
!$OMP DO
      DO J = 1, G_M2
          DO I = 1, G_M1
              A(7, I, J, G_M3) = 0
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO K = 2, G_M3
          DO J = 1, G_M2
              DO I = 1, G_M1
                  COEFF = COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I + 1, J, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I, J + 1, K)
     $                + COEFF_T_SHAPE(G_M1, G_M2, G_M3, I + 1, J + 1, K)
                  A(1, I, J, K) = -.25 * COEFF * INV_H
                  A(7, I, J, K - 1) = -.25 * COEFF * INV_H
              END DO
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP END PARALLEL

      RETURN
      END
