*     $Id: setup_prob_s.f,v 1.1 2000/06/22 07:27:46 tatebe Exp $

*
*     3-Dimansional Poisson Problem with Dirichlet Condition
*
*     G_M1 (and G_M2) is assumed to be power of 2 minus 1.
*

*
*     Calculate diffusion factor
*
*     1 <= {G_I, G_J} <= {G_M1 + 1, G_M2 + 1}
*

      DOUBLE PRECISION
     $    FUNCTION GET_COEFF(G_M1, G_M2, G_M3, G_I, G_J, G_K)
*
      INTEGER G_M1, G_M2, G_M3, G_I, G_J, G_K
*
      DOUBLE PRECISION K1
      PARAMETER (K1 = 1.0)

      GET_COEFF = K1

      RETURN
      END

*
*
*

      SUBROUTINE SETUP_PROB_DIRICHLET_S(G_M1, G_M2, G_M3, A)
*
      INTEGER   NUM_DIAG
      PARAMETER (NUM_DIAG = 7)
*
      INTEGER   G_M1, G_M2, G_M3
      REAL*8    A(NUM_DIAG, G_M1, G_M2, G_M3)
*
      DOUBLE PRECISION GET_COEFF
*
      INTEGER   I, J, K
      REAL*8    COEFF, INV_H

!$OMP PARALLEL PRIVATE(I, J, K, COEFF, INV_H)
!$OMP&         FIRSTPRIVATE(G_M1, G_M2, G_M3)

      INV_H = (G_M1 + 1.0) * (G_M1 + 1.0)

*     Diagonal Elements

!$OMP DO
      DO K = 1, G_M3
          DO J = 1, G_M2
              DO I = 1, G_M1
                  COEFF = GET_COEFF(G_M1, G_M2, G_M3, I, J, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I, J + 1, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I + 1, J, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I + 1, J + 1, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I, J, K + 1)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I, J + 1, K + 1)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I + 1, J, K + 1)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I+1, J+1, K+1)
                  A(4, I, J, K) = .75 * COEFF * INV_H
              END DO
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO K = 1, G_M3
          DO J = 1, G_M2
              A(3, 1, J, K) = 0

              DO I = 2, G_M1
                  COEFF = GET_COEFF(G_M1, G_M2, G_M3, I, J, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I, J + 1, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I, J, K + 1)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I, J + 1, K + 1)
                  A(3, I, J, K) = -.25 * COEFF * INV_H
                  A(5, I - 1, J, K) = -.25 * COEFF * INV_H
              END DO

              A(5, G_M1, J, K) = 0
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO K = 1, G_M3
          DO I = 1, G_M1
              A(2, I, 1, K) = 0
          END DO

          DO I = 1, G_M1
              A(6, I, G_M2, K) = 0
          END DO

          DO J = 2, G_M2
              DO I = 1, G_M1
                  COEFF = GET_COEFF(G_M1, G_M2, G_M3, I, J, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I + 1, J, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I, J, K + 1)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I + 1, J, K + 1)
                  A(2, I, J, K) = -.25 * COEFF * INV_H
                  A(6, I, J - 1, K) = -.25 * COEFF * INV_H
              END DO
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO J = 1, G_M2
          DO I = 1, G_M1
              A(1, I, J, 1) = 0
          END DO
      END DO
!$OMP END DO NOWAIT
!$OMP DO
      DO J = 1, G_M2
          DO I = 1, G_M1
              A(7, I, J, G_M3) = 0
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO K = 2, G_M3
          DO J = 1, G_M2
              DO I = 1, G_M1
                  COEFF = GET_COEFF(G_M1, G_M2, G_M3, I, J, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I + 1, J, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I, J + 1, K)
     $                + GET_COEFF(G_M1, G_M2, G_M3, I + 1, J + 1, K)
                  A(1, I, J, K) = -.25 * COEFF * INV_H
                  A(7, I, J, K - 1) = -.25 * COEFF * INV_H
              END DO
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP END PARALLEL

      RETURN
      END
