*
*     main program
*
*     $Id: main_s.f,v 1.10 2002/05/02 02:12:49 tatebe Exp $
*

*
*     Copyright(C) 1999, 2000 Osamu Tatebe, all rights reserved,
*     no warranty.
*
*     This software is a free software.  All rights of this software
*     belong to Osamu Tatebe.  You can redistribute this whole package
*     as it is if you do not modify and inform me by E-mail.
*

*
*     Restriction:
*
*     Let M1 = M_1 * 2^g_1 - 1 and M1 = M_2 * 2^g_2 - 1 with M_1 and
*     M_2 >= 2, (min(g_1, g_2) + 1) is maximum grid level for
*     dirichlet-boundary problem.
*

      PROGRAM SAMPLE
*
      INTEGER   MAX_GRID_LEVEL, MAX_M1, MAX_M2, MAX_N
      INTEGER   NUM_DIAG

      PARAMETER (MAX_GRID_LEVEL = 9)

      PARAMETER (MAX_M1 = 2 ** MAX_GRID_LEVEL)
      PARAMETER (MAX_M2 = MAX_M1, MAX_N = (MAX_M1 + 2) * (MAX_M2 + 2))
      PARAMETER (NUM_DIAG = 5)

      INTEGER   G_N, G_M1(MAX_GRID_LEVEL + 2), G_M2(MAX_GRID_LEVEL + 2)
      INTEGER   L_L(MAX_GRID_LEVEL + 2)
      REAL*8    A(NUM_DIAG, MAX_N * 4 / 3), B(MAX_N), X1(MAX_N)
*     Work Space for MGCG
      REAL*8    WS(4 * MAX_N + MAX_N * 4 / 3
     $             + MAX_N * 5 / 3 + 2 * (MAX_M1 + MAX_M2)
     $             + 4 * (MAX_GRID_LEVEL - 1))
      SAVE      A, B, X1, WS

      REAL*8    EPS
      PARAMETER (EPS = 1.0D-11)

      INTEGER   PROB_NO
      INTEGER   LOG_M, M1, M2, N, N1
      INTEGER   G_LEV, GRIDS, NUM_C
      INTEGER   I
*      INTEGER   J
*
!$    INTEGER   OMP_GET_NUM_THREADS
*
      INTEGER   IER
      REAL*4    T0, T1, SECOND
      REAL*8    FLOP_MGCG
      REAL*8    FLOP, MFLOPS

*
*     Problem and problem size
*

      PROB_NO = 3
      LOG_M = 9

*
*     Parameters for MGCG
*

      GRIDS = 9
      NUM_C = 1

*
*     Initialization
*

      IF (PROB_NO .EQ. 1 .OR. PROB_NO .EQ. 3) THEN
          M1 = 2 ** LOG_M - 1
      ELSE IF (PROB_NO .EQ. 2) THEN
          M1 = 2 ** LOG_M
      END IF
      M2 = M1

      N = M1 * M2
      N1 = (M1 + 2) * (M2 + 2)

      WRITE (6, 1001) PROB_NO
 1001 FORMAT ('problem: ', I2)
      WRITE (6, 1002) N, M1, M2
 1002 FORMAT ('global: n = ', I8, ' (', I4, ' x ', I4, ' )')
      WRITE (6, 1004) GRIDS
 1004 FORMAT ('grids = ', I3)

      CALL ASSERT(N .LE. MAX_N, 'main_s.f', 85)

*
*     For OpenMP
*

!$OMP PARALLEL
!$OMP SINGLE
!$    WRITE (*,*) '#threads = ', OMP_GET_NUM_THREADS()
!$OMP END SINGLE
!$OMP END PARALLEL

*
*     Set up a problem
*

      G_LEV = 1

      G_N = N
      G_M1(G_LEV) = M1
      G_M2(G_LEV) = M2

      L_L(G_LEV) = 0

*     WHILE (G_N > 0)
   10 IF (G_N .LE. 0) GO TO 50

          IF (PROB_NO .EQ. 1) THEN
*             /*  Dirichlet condition */
              CALL SETUP_PROB_DIRICHLET_S(G_N, G_M1(G_LEV),
     $                                    A(1, L_L(G_LEV) + 1))
          ELSE IF (PROB_NO .EQ. 2) THEN
*             /*  Neumann condition */
              CALL SETUP_PROB_NEUMANN_S(G_N, G_M1(G_LEV),
     $                                  A(1, L_L(G_LEV) + 1))
          ELSE IF (PROB_NO .EQ. 3) THEN
*             /*  T-shape problem */
              CALL SETUP_PROB_T_SHAPE_S(G_N, G_M1(G_LEV),
     $                                  A(1, L_L(G_LEV) + 1))
          ELSE
              WRITE (6, 1005)
 1005         FORMAT ('no problem')
              GO TO 90
          END IF

*          write (*,*) G_LEV, ':'
*          do i = 1, G_N
*              write (6,9999) (A(J, L_L(G_LEV) + I), J=1,5)
* 9999         format (F8.0, F8.0, F8.0, F8.0, F8.0)
*          end do

          CALL REST_DIM(G_M1(G_LEV), G_M2(G_LEV),
     $                  G_M1(G_LEV + 1), G_M2(G_LEV + 1))

          G_LEV = G_LEV + 1

          L_L(G_LEV) = L_L(G_LEV - 1) + G_N
          G_N = G_M1(G_LEV) * G_M2(G_LEV)

      GO TO 10

   50 CONTINUE

      CALL ASSERT(GRIDS .LT. G_LEV, 'main_s.f', 148)

*
*     Source term
*

!$OMP PARALLEL DO
      DO I = 1, N
          B(I) = 100.0
      END DO

*
*     Initial Approximate
*

!$OMP PARALLEL DO PRIVATE(I)
      DO I = 1, N1
          X1(I) = 0.0
      END DO

*
*     Solve
*

      I = 100

      T0 = SECOND()

      CALL MGCG(GRIDS, NUM_C, G_M1, G_M2,
     $          A, B, X1, I, EPS,
     $          WS, IER)

      T1 = SECOND()
      WRITE(*,*) 'iter = ', I, ', time = ', T1 - T0
*      WRITE (*,*) I

      FLOP = FLOP_MGCG(GRIDS, G_M1, G_M2, NUM_C, I)
      MFLOPS = FLOP / (T1 - T0) / 1000000
      WRITE (6, 1012) MFLOPS
 1012 FORMAT (F14.6, ' MFLOPS')

   90 CONTINUE

      END


*
*     Calculate the num. of floating operations of MG
*

      REAL*8
     $    FUNCTION FLOP_VMG(GRID, M1, M2, NUM_C)
*
      INTEGER   GRID, M1, M2, NUM_C
*
      REAL*8    N, N1
      INTEGER   MN1, MN2, MM1, MM2
      INTEGER   I

      FLOP_VMG = 0.0

      MN1 = M1
      MN2 = M2
      DO I = 1, GRID - 1
          CALL REST_DIM(MN1, MN2, MM1, MM2)
          N = MN1 * MN2
          N1 = MM1 * MM2

          FLOP_VMG = FLOP_VMG + 13.0 * N + 9.0 * N1 + 18.0 * N
          MN1 = MM1
          MN2 = MM2
      END DO

      N = MN1 * MN2
      IF (N .EQ. 1) THEN
          FLOP_VMG = FLOP_VMG + 1.0 
      ELSE
          FLOP_VMG = FLOP_VMG + 9.0 * N * NUM_C + N * 9.0 / 2
      END IF

      RETURN
      END

*
*     Calculate the num. of floating operations of MGCG
*

      REAL*8
     $    FUNCTION FLOP_MGCG(GRID, M1, M2, NUM_C, NUM_MGCG)
*
      INTEGER   GRID, M1, M2, NUM_C, NUM_MGCG
*
      REAL*8    FLOP_VMG
*
      REAL*8    N, F_MG

      N = M1 * M2

      F_MG = FLOP_VMG(GRID, M1, M2, NUM_C)

      FLOP_MGCG = 14.0 * N + 4.0 * N / 3.0
     $    + F_MG + 17.0 * N
     $    + (F_MG + 4.0 * N + 17.0 * N) * (NUM_MGCG - 1.0)

      RETURN
      END
