*
*     Serial Multigrid method
*
*     Solve A x = b.
*
*     $Id: mg_s.f,v 1.5 2000/04/23 18:40:32 tatebe Exp $
*

*
*     Copyright(C) 1999, 2000 Osamu Tatebe, all rights reserved,
*     no warranty.
*
*     This software is a free software.  All rights of this software
*     belong to Osamu Tatebe.  You can redistribute this whole package
*     as it is if you do not modify and inform me by E-mail.
*

      SUBROUTINE MG_S(G_LEV, NUM_C, G_M11, G_M21, G_M1, G_M2,
     $                A1, INV_A, B, X, R, R1, X1)
*
      INCLUDE 'paraf.h'
*
      INTEGER   G_LEV, NUM_C, G_M1(G_LEV), G_M2(G_LEV)
      INTEGER   G_M11, G_M21
      REAL*8    A1(NUM_DIAG, G_M11 * G_M21 * 4 / 3)
      REAL*8    INV_A(G_M11 * G_M21 * 4 / 3)
      REAL*8    B(G_M11 * G_M21)
      REAL*8    X(G_M11 + 2, G_M21 + 2)
*     Work space
*     residual on each grid level
      REAL*8    R(G_M11 * G_M21)
      REAL*8    R1(G_M11 * G_M21 / 3)
*     Approximation on each grid level
      REAL*8    X1(G_M11 * G_M21 / 3
     $             + 2 * (G_M11 + G_M21) + 4 * (G_LEV - 1))
*
      INTEGER   M1, M2
      INTEGER   L_L(MAX_NUM_GRID), L_L1(MAX_NUM_GRID)
      INTEGER   L_L2(MAX_NUM_GRID)
      INTEGER   GRID
      INTEGER   J

      M1 = G_M11
      M2 = G_M21

      IF (G_LEV .LE. 1) THEN

*         /*  On the coarsest grid  */

          CALL RB_GS_S(M1, M2, A1, INV_A, B, X, NUM_C)
          CALL R_GS_S(M1, M2, A1, INV_A, B, X)

      ELSE

          GRID = 1
          L_L(GRID) = 1

*         /***  Pre-smoothing  ***/

          CALL R_GS_S(M1, M2, A1, INV_A, B, X)
          CALL B_GS_S(M1, M2, A1, INV_A, B, X)

*         /***  Coarse grid correction  ***/

*         /*  r = b - A x */

          CALL RES_VEC_S(M1, M2, B, A1, X, R)

          CALL RESTRICT_S(G_M1(GRID), G_M2(GRID), R,
     $                    G_M1(GRID + 1), G_M2(GRID + 1), R1)

          L_L(GRID + 1) = L_L(GRID) + G_M1(GRID) * G_M2(GRID)
          L_L1(GRID + 1) = 1
          L_L2(GRID + 1) = 1

          GRID = GRID + 1

          IF (GRID .GE. G_LEV) GO TO 20

   10     CONTINUE

*             /***  Pre-smoothing  ***/

!$OMP DO
              DO J = 0, (G_M1(GRID) + 2) * (G_M2(GRID) + 2) - 1
                  X1(L_L2(GRID) + J) = 0.0
              END DO

              CALL R_GS_S(G_M1(GRID), G_M2(GRID),
     $                    A1(1, L_L(GRID)), INV_A(L_L(GRID)),
     $                    R1(L_L1(GRID)), X1(L_L2(GRID)))
              CALL B_GS_S(G_M1(GRID), G_M2(GRID),
     $                    A1(1, L_L(GRID)), INV_A(L_L(GRID)),
     $                    R1(L_L1(GRID)), X1(L_L2(GRID)))

*             /***  Coarse grid correction  ***/

*             /*  r = b - A x */

              CALL RES_VEC_S(G_M1(GRID), G_M2(GRID),
     $                       R1(L_L1(GRID)), A1(1, L_L(GRID)),
     $                       X1(L_L2(GRID)), R)

              L_L1(GRID+1) = L_L1(GRID) + G_M1(GRID) * G_M2(GRID)
              L_L2(GRID+1) = L_L2(GRID) + (G_M1(GRID)+2)*(G_M2(GRID)+2)
              L_L(GRID+1) = L_L(GRID) + G_M1(GRID) * G_M2(GRID)

              CALL RESTRICT_S(G_M1(GRID), G_M2(GRID), R,
     $                        G_M1(GRID + 1), G_M2(GRID + 1),
     $                        R1(L_L1(GRID + 1)))

              GRID = GRID + 1

          IF (GRID .LT. G_LEV) GO TO 10

   20     CONTINUE

*         /*  On the coarsest grid  */

!$OMP DO
          DO J = 0, (G_M1(GRID) + 2) * (G_M2(GRID) + 2) - 1
              X1(L_L2(GRID) + J) = 0.0
          END DO

          CALL RB_GS_S(G_M1(GRID), G_M2(GRID),
     $                 A1(1, L_L(GRID)), INV_A(L_L(GRID)),
     $                 R1(L_L1(GRID)), X1(L_L2(GRID)), NUM_C)
          CALL R_GS_S(G_M1(GRID), G_M2(GRID),
     $                A1(1, L_L(GRID)), INV_A(L_L(GRID)),
     $                R1(L_L1(GRID)), X1(L_L2(GRID)))

          IF (GRID .LE. 2) GO TO 40

   30     CONTINUE

              CALL PROLONG_S(G_M1(GRID), G_M2(GRID), X1(L_L2(GRID)),
     $                       G_M1(GRID - 1), G_M2(GRID - 1), R)

              GRID = GRID - 1

              CALL CORRECT_SOLUTION(G_M1(GRID), G_M2(GRID),
     $                              X1(L_L2(GRID)), R)

*             /***  Post-smoothing  ***/

              CALL B_GS_S(G_M1(GRID), G_M2(GRID),
     $                    A1(1, L_L(GRID)), INV_A(L_L(GRID)),
     $                    R1(L_L1(GRID)), X1(L_L2(GRID)))
              CALL R_GS_S(G_M1(GRID), G_M2(GRID),
     $                    A1(1, L_L(GRID)), INV_A(L_L(GRID)),
     $                    R1(L_L1(GRID)), X1(L_L2(GRID)))

          IF (GRID .GT. 2) GO TO 30

   40     CONTINUE

          CALL PROLONG_S(G_M1(GRID), G_M2(GRID), X1(L_L2(GRID)),
     $                   G_M1(GRID - 1), G_M2(GRID - 1), R)

          GRID = GRID - 1

          CALL CORRECT_SOLUTION(M1, M2, X, R)

*         /***  Post-smoothing  ***/

          CALL B_GS_S(M1, M2, A1, INV_A, B, X)
          CALL R_GS_S(M1, M2, A1, INV_A, B, X)

      END IF

      RETURN
      END


      SUBROUTINE CORRECT_SOLUTION(M1, M2, X, R)
      INTEGER M1, M2
      REAL*8 X(0:M1+1, 0:M2+1), R(M1, M2)

      INTEGER I, J

*!$OMP PARALLEL DO PRIVATE(I) FIRSTPRIVATE(M1, M2)
!$OMP DO
      DO J = 1, M2
          DO I = 1, M1
              X(I, J) = X(I, J) + R(I, J)
          END DO
      END DO

      RETURN
      END
