*     /*****  p1 = A p, pp = (p, p1) *****/
*
*     $Id: mul_s.f,v 1.5 2000/04/20 19:37:30 tatebe Exp $
*

*
*     Compute only inner points
*

      SUBROUTINE MUL_VEC_NORM_INNER_S(M1, M2, A1, P, P1, NORM)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A1(NUM_DIAG, M1, M2), P(0:M1+1, 0:M2+1)
      REAL*8    P1(M1, M2), NORM
*
      INTEGER   I, J
      REAL*8    TP

!$OMP PARALLEL DO PRIVATE(I, TP) FIRSTPRIVATE(M1, M2)
!$OMP&            REDUCTION (+:NORM)
      DO J = 1, M2
          DO I = 1, M1
              TP =
     $            (A1(1, I, J) * P(I, J - 1) +
     $             A1(2, I, J) * P(I - 1, J) +
     $             A1(3, I, J) * P(I, J) +
     $             A1(4, I, J) * P(I + 1, J) +
     $             A1(5, I, J) * P(I, J + 1))
              P1(I, J) = TP
              NORM = NORM + TP * P(I, J)
          END DO
      END DO

      RETURN
      END

**
**     Compute only boundary points
**
*
*      SUBROUTINE MUL_VEC_NORM_BOUND_S(M1, M2, A1, P, P1, NORM)
**
*      INCLUDE 'paraf.h'
**
*      INTEGER   M1, M2
*      REAL*8    A1(NUM_DIAG, M1, M2), P(0:M1+1, 0:M2+1)
*      REAL*8    P1(M1, M2), NORM
**
*      INTEGER   I, J
*      REAL*8    TP
*
*      J = 1
*      DO I = 1, M1
*          TP =
*     $        (A1(1, I, J) * P(I, J - 1) +
*     $         A1(2, I, J) * P(I - 1, J) +
*     $         A1(3, I, J) * P(I, J) +
*     $         A1(4, I, J) * P(I + 1, J) +
*     $         A1(5, I, J) * P(I, J + 1))
*          P1(I, J) = TP
*          NORM = NORM + TP * P(I, J)
*      END DO
*
*      DO J = 2, M2 - 1
*          I = 1
*          TP =
*     $        (A1(1, I, J) * P(I, J - 1) +
*     $         A1(2, I, J) * P(I - 1, J) +
*     $         A1(3, I, J) * P(I, J) +
*     $         A1(4, I, J) * P(I + 1, J) +
*     $         A1(5, I, J) * P(I, J + 1))
*          P1(I, J) = TP
*          NORM = NORM + TP * P(I, J)
*
*          I = M1
*          TP =
*     $        (A1(1, I, J) * P(I, J - 1) +
*     $         A1(2, I, J) * P(I - 1, J) +
*     $         A1(3, I, J) * P(I, J) +
*     $         A1(4, I, J) * P(I + 1, J) +
*     $         A1(5, I, J) * P(I, J + 1))
*          P1(I, J) = TP
*          NORM = NORM + TP * P(I, J)
*      END DO
*
*      J = M2
*      DO I = 1, M1
*          TP =
*     $        (A1(1, I, J) * P(I, J - 1) +
*     $         A1(2, I, J) * P(I - 1, J) +
*     $         A1(3, I, J) * P(I, J) +
*     $         A1(4, I, J) * P(I + 1, J) +
*     $         A1(5, I, J) * P(I, J + 1))
*          P1(I, J) = TP
*          NORM = NORM + TP * P(I, J)
*      END DO
*      
*      RETURN
*      END
*
**
**

*
*
*

      SUBROUTINE MUL_VEC_NORM_S(M1, M2, A1, P, P1, NORM)
*
      INCLUDE   'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A1(NUM_DIAG, M1 * M2), P(M1+2, M2+2)
      REAL*8    P1(M1 * M2), NORM
*
*      NORM = 0.0

      IF (M1 * M2 .EQ. 0) GO TO 10

      CALL MUL_VEC_NORM_INNER_S(M1, M2, A1, P, P1, NORM)

*      CALL MUL_VEC_NORM_BOUND_S(M1, M2, A1, P, P1, NORM)
      
   10 CONTINUE

      RETURN
      END
