*
*     Prolongation
*
*     $Id: prog_s.f,v 1.6 2000/05/01 17:32:35 tatebe Exp $
*

      SUBROUTINE PROLONG_INNER_S(MM1, MM2, X, M1, M2, Y)
*
      INTEGER   MM1, MM2, M1, M2
      REAL*8    X(0:MM1+1, 0:MM2+1), Y(M1, M2)
*
      INTEGER   I, I1, J, J1

      IF (MM1 * MM2 .EQ. 0) RETURN

*     /*  Inner points */

*!$OMP PARALLEL PRIVATE(J, I, J1, I1)

!$OMP DO
      DO J = 1, MM2
          J1 = 2 * J
          DO I = 1, MM1
              I1 = 2 * I
              Y(I1, J1) = X(I, J)
          END DO
      END DO

!$OMP DO
      DO J = 2, M2, 2
          Y(1, J) = .5 * Y(2, J)
          DO I = 3, M1 - 1, 2
              Y(I, J) = .5 * (Y(I - 1, J) + Y(I + 1, J))
          END DO
          IF (I .LE. M1) THEN
              Y(I, J) = .5 * Y(I - 1, J)
          END IF
      END DO

!$OMP DO
      DO J = 3, M2 - 1, 2
          DO I = 1, M1
              Y(I, J) = .5 * (Y(I, J - 1) + Y(I, J + 1))
          END DO
      END DO
*!$OMP END DO NOWAIT

!$OMP SECTIONS
!$OMP SECTION
      DO I = 1, M1
          Y(I, 1) = .5 * Y(I, 2)
      END DO
!$OMP SECTION
      IF ((M2 / 2) * 2 .NE. M2) THEN
          J = M2
          DO I = 1, M1
              Y(I, J) = .5 * Y(I, J - 1)
          END DO
      END IF
!$OMP END SECTIONS
*!$OMP END SECTIONS NOWAIT

*!$OMP END PARALLEL

      RETURN
      END

*
*
*

      SUBROUTINE PROLONG_S(MM1, MM2, X, M1, M2, Y)
*
      INTEGER   MM1, MM2, M1, M2
      REAL*8    X(MM1 + 2, MM2 + 2), Y(M1 * M2)

      CALL PROLONG_INNER_S(MM1, MM2, X, M1, M2, Y)

      RETURN
      END
