*
*     Serial Red-Black Gauss-Seidel method
*
*     $Id: rb_s.f,v 1.6 2000/04/23 18:40:32 tatebe Exp $
*

      SUBROUTINE RB_GS_S(M1, M2, A, INV_A, B, X, ITER)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1 * M2), INV_A(M1 * M2), B(M1 * M2)
      REAL*8    X(M1 + 2, M2 + 2)
      INTEGER   ITER
*
      INTEGER   I

      DO I = 1, ITER
          CALL R_GS_S(M1, M2, A, INV_A, B, X)
          CALL B_GS_S(M1, M2, A, INV_A, B, X)
      END DO

      RETURN
      END


      SUBROUTINE BR_GS_S(M1, M2, A, INV_A, B, X, ITER)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1 * M2), INV_A(M1 * M2), B(M1 * M2)
      REAL*8    X(M1 + 2, M2 + 2)
      INTEGER   ITER
*
      INTEGER   I

      DO I = 1, ITER
          CALL B_GS_S(M1, M2, A, INV_A, B, X)
          CALL R_GS_S(M1, M2, A, INV_A, B, X)
      END DO

      RETURN
      END

*
*     Update only Red points
*

      SUBROUTINE R_GS_INNER_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1, M2), INV_A(M1, M2)
      REAL*8    B(M1, M2), X(0:M1+1, 0:M2+1)
*
      INTEGER   I, J

*!$OMP PARALLEL FIRSTPRIVATE(M1, M2) PRIVATE(I, J)
!$OMP DO
      DO J = 1, M2 - 1, 2
          DO I = 1, M1, 2
              X(I, J) =
     $            (B(I, J) -
     $             A(1, I, J) * X(I, J - 1) -
     $             A(2, I, J) * X(I - 1, J) -
     $             A(4, I, J) * X(I + 1, J) -
     $             A(5, I, J) * X(I, J + 1)) *
     $            INV_A(I, J)
          END DO

          DO I = 2, M1, 2
              X(I, J+1) =
     $            (B(I, J+1) -
     $             A(1, I, J+1) * X(I, J+1 - 1) -
     $             A(2, I, J+1) * X(I - 1, J+1) -
     $             A(4, I, J+1) * X(I + 1, J+1) -
     $             A(5, I, J+1) * X(I, J+1 + 1)) *
     $            INV_A(I, J+1)
          END DO
      END DO
*!$OMP END DO NOWAIT
!$OMP END DO

      IF ((M2 / 2) * 2 .NE. M2) THEN
          J = M2
!$OMP DO
          DO I = 1, M1, 2
              X(I, J) =
     $            (B(I, J) -
     $             A(1, I, J) * X(I, J - 1) -
     $             A(2, I, J) * X(I - 1, J) -
     $             A(4, I, J) * X(I + 1, J) -
     $             A(5, I, J) * X(I, J + 1)) *
     $            INV_A(I, J)
          END DO
      END IF
*!$OMP END PARALLEL

      RETURN
      END

*
*
*

      SUBROUTINE R_GS_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1 * M2), INV_A(M1 * M2), B(M1 * M2)
      REAL*8    X(M1 + 2, M2 + 2)

      IF (M1 * M2 .EQ. 0) GO TO 10

      CALL R_GS_INNER_S(M1, M2, A, INV_A, B, X)

   10 CONTINUE

      RETURN
      END

*
*
*     Update only Black points
*
*

      SUBROUTINE B_GS_INNER_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1, M2), INV_A(M1, M2)
      REAL*8    B(M1, M2), X(0:M1+1, 0:M2+1)
*
      INTEGER   I, J

*!$OMP PARALLEL FIRSTPRIVATE(M1, M2) PRIVATE(I, J)
!$OMP DO
      DO J = 1, M2 - 1, 2
          DO I = 2, M1, 2
              X(I, J) =
     $            (B(I, J) -
     $             A(1, I, J) * X(I, J - 1) -
     $             A(2, I, J) * X(I - 1, J) -
     $             A(4, I, J) * X(I + 1, J) -
     $             A(5, I, J) * X(I, J + 1)) *
     $            INV_A(I, J)
          END DO

          DO I = 1, M1, 2
              X(I, J+1) =
     $            (B(I, J+1) -
     $             A(1, I, J+1) * X(I, J+1 - 1) -
     $             A(2, I, J+1) * X(I - 1, J+1) -
     $             A(4, I, J+1) * X(I + 1, J+1) -
     $             A(5, I, J+1) * X(I, J+1 + 1)) *
     $            INV_A(I, J+1)
          END DO
      END DO
*!$OMP END DO NOWAIT
!$OMP END DO

      IF ((M2 / 2) * 2 .NE. M2) THEN
          J = M2
!$OMP DO
          DO I = 2, M1, 2
              X(I, J) =
     $            (B(I, J) -
     $             A(1, I, J) * X(I, J - 1) -
     $             A(2, I, J) * X(I - 1, J) -
     $             A(4, I, J) * X(I + 1, J) -
     $             A(5, I, J) * X(I, J + 1)) *
     $            INV_A(I, J)
          END DO
      END IF
*!$OMP END PARALLEL

      RETURN
      END

*
*
*

      SUBROUTINE B_GS_S(M1, M2, A, INV_A, B, X)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    A(NUM_DIAG, M1 * M2), INV_A(M1 * M2), B(M1 * M2)
      REAL*8    X(M1 + 2, M2 + 2)

      IF (M1 * M2 .EQ. 0) GO TO 10

      CALL B_GS_INNER_S(M1, M2, A, INV_A, B, X)

   10 CONTINUE

      RETURN
      END
