*     /*****  r = b - A x0  *****/
*
*     $Id: res1_s.f,v 1.6 2000/04/23 18:40:32 tatebe Exp $
*

*
*     Compute only inner points
*

      SUBROUTINE RES_VEC_INNER_S(M1, M2, B, A1, X, R)
*
      INCLUDE 'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    B(M1, M2), A1(NUM_DIAG, M1, M2)
      REAL*8    X(0:M1+1, 0:M2+1), R(M1, M2)
*
      INTEGER   I, J

*!$OMP PARALLEL DO PRIVATE(I, J) FIRSTPRIVATE(M1, M2)
!$OMP DO
      DO J = 1, M2
          DO I = 1, M1
              R(I, J) = B(I, J) -
     $            (A1(1, I, J) * X(I, J - 1) +
     $             A1(2, I, J) * X(I - 1, J) +
     $             A1(3, I, J) * X(I, J) +
     $             A1(4, I, J) * X(I + 1, J) +
     $             A1(5, I, J) * X(I, J + 1))
          END DO
      END DO

      RETURN
      END

*
*
*

      SUBROUTINE RES_VEC_S(M1, M2, B, A1, X, R)
*
      INCLUDE   'paraf.h'
*
      INTEGER   M1, M2
      REAL*8    B(M1 * M2), A1(NUM_DIAG, M1 * M2), X(M1 + 2, M2 + 2)
      REAL*8    R(M1 * M2)

      IF (M1 * M2 .EQ. 0) GO TO 10

      CALL RES_VEC_INNER_S(M1, M2, B, A1, X, R)

   10 CONTINUE

      RETURN
      END
