*
*     Restriction in 2 dimensions
*
*     $Id: rest_s.f,v 1.5 2000/04/23 18:40:32 tatebe Exp $
*

      SUBROUTINE REST_DIM(M1, M2, MM1, MM2)
*
      INTEGER   M1, M2, MM1, MM2

      MM1 = M1 / 2
      MM2 = M2 / 2

      RETURN
      END


*
*     Restriction
*

      SUBROUTINE REST_INNER_S(N, M, X, N1, M1, Y)
*
      INTEGER   N, M, N1, M1
      REAL*8    X(M, N / M), Y(M1, N1 / M1)
*
      REAL*8    INV_16
      PARAMETER (INV_16 = 1.0 / 16)
*
      INTEGER   I, I1, J, J1

*     /*  Inner points */

*!$OMP PARALLEL DO PRIVATE (I1, J, J1) FIRSTPRIVATE(N, M)
!$OMP DO
      DO I = 2, N / M - 1, 2
          I1 = I / 2
          DO J = 2, M - 1, 2
              J1 = J / 2
              Y(J1, I1) = (4.0 * X(J, I) +
     $                     2.0 * (X(J, I - 1) + X(J - 1, I) +
     $                            X(J + 1, I) + X(J, I + 1)) +
     $                     X(J - 1, I - 1) + X(J + 1, I - 1) + 
     $                     X(J - 1, I + 1) + X(J + 1, I + 1))
     $                         * INV_16
          END DO
      END DO

      RETURN
      END

*
*

      SUBROUTINE REST_BOUND_S(M1, M2, X, MM1, MM2, Y)
*
      INTEGER   M1, M2, MM1, MM2
      REAL*8    X(M1 * M2), Y(MM1 * MM2)
*
      REAL*8    INV_16
      PARAMETER (INV_16 = 1.0 / 16)
*
      INTEGER   I, I1
      INTEGER   M4, N, NN

      M4 = 2 * M1
      N = M1 * M2
      NN = MM1 * MM2

*     /*  If M1 is even  */

!$OMP SECTIONS

!$OMP SECTION
      IF ((M1 / 2) * 2 .EQ. M1) THEN
          I1 = MM1
          DO I = M4, N - M1, M4
              Y(I1) = (4.0 * X(I) +
     $                 2.0 * (X(I - M1) + X(I - 1) +
     $                        X(I + M1)) +
     $                 X(I - M1 - 1) + X(I + M1 - 1)) * INV_16
              I1 = I1 + MM1
          END DO
      END IF

*     /*  IF M2 is even  */

!$OMP SECTION
      IF ((M2 / 2) * 2 .EQ. M2) THEN
          I1 = NN - MM1 + 1
          DO I = N - M1 + 2, N - 1, 2
              Y(I1) = (4.0 * X(I) +
     $                 2.0 * (X(I - M1) + X(I - 1) +
     $                        X(I + 1)) +
     $                 X(I - M1 - 1) + X(I - M1 + 1)) * INV_16
              I1 = I1 + 1
          END DO

          IF (I .LE. N) THEN
              Y(I1) = (4.0 * X(I) +
     $                 2.0 * (X(I - M1) + X(I - 1)) +
     $                 X(I - M1 - 1)) * INV_16
          END IF
      END IF

!$OMP END SECTIONS

      RETURN
      END

*
*

*
*
*

      SUBROUTINE RESTRICT_S(M1, M2, X, MM1, MM2, Y)
*
      INTEGER   M1, M2, MM1, MM2
      REAL*8    X(M1 * M2), Y(MM1 * MM2)
*
      INTEGER   N, NN

      N = M1 * M2
      NN = MM1 * MM2

      CALL REST_INNER_S(N, M1, X, NN, MM1, Y)

      CALL REST_BOUND_S(M1, M2, X, MM1, MM2, Y)

      RETURN
      END
