*     $Id: setup_prob3_s.f,v 1.3 2000/04/20 18:36:52 tatebe Exp $

*
*     2-Dimansional Poisson Problem with Dirichlet Condition
*
*     Diffusion factor has a discontinuity with 'T-shape'.
*
*     G_M1 (and G_M2) is assumed to be power of 2 minus 1.
*

*
*     Calculate diffusion factor
*
*     1 <= {G_I, G_J} <= {G_M1 + 1, G_M2 + 1}
*

      DOUBLE PRECISION
     $    FUNCTION COEFF_T_SHAPE_S(G_M1, G_M2, G_I, G_J)
*
      INTEGER G_M1, G_M2, G_I, G_J
*
      DOUBLE PRECISION K1, K2
      PARAMETER (K1 = 1.0, K2 = 1000.0)
*
      INTEGER T_G_I
      INTEGER X(7), Y(7)
      INTEGER I

      DO I = 1, 7
          X(I) = (G_M1 * I + 7) / 8
          Y(I) = (G_M2 * I + 7) / 8
      END DO

*     Symmetry in X-axis

      IF (G_I .GT. X(4)) THEN
          T_G_I = 2 * X(4) - G_I + 1
      ELSE
          T_G_I = G_I
      END IF
*

      IF (G_J .LE. Y(1) .OR. G_J .GT. Y(7)) THEN
          COEFF_T_SHAPE_S = K1
      ELSE IF (G_J .GT. Y(1) .AND. T_G_I .LE. X(1)) THEN
          COEFF_T_SHAPE_S = K1
      ELSE IF (G_J .GT. Y(3) .AND. T_G_I .LE. X(3)) THEN
          COEFF_T_SHAPE_S = K1
      ELSE
          COEFF_T_SHAPE_S = K2
      END IF

      RETURN
      END

*
*
*

      DOUBLE PRECISION
     $    FUNCTION COEFF_T_SHAPE(G_M1, G_M2, G_I, G_J)
*
      INTEGER G_M1, G_M2, G_I, G_J
*
      INTEGER B_X, B_Y
      DOUBLE PRECISION COEFF_T_SHAPE_S
      DOUBLE PRECISION COEFF
      INTEGER I, J

      IF (G_M1 .GT. 4 .OR. G_M2 .GT. 4) THEN

          COEFF_T_SHAPE = COEFF_T_SHAPE_S(G_M1, G_M2, G_I, G_J)

*     SPECIAL CARE: SMALL SIZE

      ELSE

*     G_M1 and G_M2 are assumed to be 1 or 3.

          B_X = 8 / (G_M1 + 1)
          B_Y = 8 / (G_M2 + 1)

          COEFF = 0.0
          DO I = 1, B_X
              DO J = 1, B_Y
                  COEFF = COEFF
     $                  + COEFF_T_SHAPE_S(7, 7, (G_I - 1) * B_X + I, 
     $                                          (G_J - 1) * B_Y + J)
              END DO
          END DO

          COEFF_T_SHAPE = COEFF / B_X / B_Y
      END IF

      RETURN
      END

*
*
*

      SUBROUTINE SETUP_PROB_T_SHAPE_S(G_N, G_M1, A)
*
      INTEGER   NUM_DIAG
      PARAMETER (NUM_DIAG = 5)
*
      INTEGER   G_N, G_M1
      REAL*8    A(NUM_DIAG, G_N)
*
      DOUBLE PRECISION COEFF_T_SHAPE
*
      INTEGER   I, J, G_M2
      REAL*8    COEFF, INV_H

!$OMP PARALLEL PRIVATE(I, J, COEFF, INV_H, G_M2)
!$OMP&         FIRSTPRIVATE(G_N, G_M1)

      INV_H = (G_M1 + 1.0) * (G_M1 + 1.0)

      G_M2 = G_N / G_M1

!$OMP DO
      DO I = 1, G_M2
          DO J = 1, G_M1
              COEFF = COEFF_T_SHAPE(G_M1, G_M2, J, I)
     $              + COEFF_T_SHAPE(G_M1, G_M2, J, I + 1)
     $              + COEFF_T_SHAPE(G_M1, G_M2, J + 1, I)
     $              + COEFF_T_SHAPE(G_M1, G_M2, J + 1, I + 1)
              A(3, (I - 1) * G_M1 + J) = COEFF * INV_H
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO I = 1, G_M2
          A(2, (I - 1) * G_M1 + 1) = 0

          DO J = 2, G_M1
              COEFF = COEFF_T_SHAPE(G_M1, G_M2, J, I)
     $              + COEFF_T_SHAPE(G_M1, G_M2, J, I + 1)
              A(2, (I - 1) * G_M1 + J) = -.5 * COEFF * INV_H
              A(4, (I - 1) * G_M1 + J - 1) = -.5 * COEFF * INV_H
          END DO

          A(4, I * G_M1) = 0
      END DO
!$OMP END DO NOWAIT

!$OMP SECTIONS
!$OMP SECTION
      DO J = 1, G_M1
          A(1, J) = 0
      END DO
!$OMP SECTION
      DO J = 1, G_M1
          A(5, G_N - J + 1) = 0
      END DO
!$OMP END SECTIONS NOWAIT

!$OMP DO
      DO I = 2, G_M2
          DO J = 1, G_M1
              COEFF = COEFF_T_SHAPE(G_M1, G_M2, J, I)
     $              + COEFF_T_SHAPE(G_M1, G_M2, J + 1, I)
              A(1, (I - 1) * G_M1 + J) = -.5 * COEFF * INV_H
              A(5, (I - 2) * G_M1 + J) = -.5 * COEFF * INV_H
          END DO
      END DO
!$OMP END DO NOWAIT

!$OMP END PARALLEL

      RETURN
      END
