*     $Id: setup_prob_s.f,v 1.6 2000/04/20 18:36:52 tatebe Exp $

*
*     2-Dimansional Poisson Problem with Dirichlet Condition
*

      SUBROUTINE SETUP_PROB_DIRICHLET_S(GLOBAL_N, GLOBAL_M1, A)
*
      INTEGER   NUM_DIAG
      PARAMETER (NUM_DIAG = 5)
*
      INTEGER   GLOBAL_N, GLOBAL_M1
      REAL*8    A(NUM_DIAG, GLOBAL_N)
*
      INTEGER   I, J
      REAL*8    INV_H

!$OMP PARALLEL PRIVATE(I, J, INV_H)
!$OMP&         FIRSTPRIVATE(GLOBAL_N, GLOBAL_M1)

      INV_H = (GLOBAL_M1 + 1.0) * (GLOBAL_M1 + 1.0)

!$OMP DO
      DO I = 1, GLOBAL_N
          A(3, I) = 4 * INV_H
      END DO
!$OMP END DO NOWAIT

!$OMP DO
      DO I = 1, GLOBAL_N, GLOBAL_M1
          A(2, I) = 0

          DO J = I, I + GLOBAL_M1 - 2
              A(2, J + 1) = -1 * INV_H
              A(4, J) = -1 * INV_H
          END DO

          A(4, J) = 0
      END DO
!$OMP END DO NOWAIT

!$OMP SECTIONS
!$OMP SECTION
      DO I = 1, GLOBAL_M1
          A(1, I) = 0
      END DO
!$OMP SECTION
      DO I = 1, GLOBAL_M1
          A(5, GLOBAL_N - I + 1) = 0
      END DO
!$OMP END SECTIONS NOWAIT

!$OMP DO
      DO I = GLOBAL_M1 + 1, GLOBAL_N
          A(1, I) = -1 * INV_H
          A(5, GLOBAL_N - I + 1) = -1 * INV_H
      END DO
!$OMP END DO NOWAIT

!$OMP END PARALLEL

      RETURN
      END

*
*     2-Dimansional Poisson Problem with Dirichlet-Neumann Condition
*

      SUBROUTINE SETUP_PROB_NEUMANN_S(GLOBAL_N, GLOBAL_M1, A)
*
      INTEGER   NUM_DIAG
      PARAMETER (NUM_DIAG = 5)
*
      INTEGER   GLOBAL_N, GLOBAL_M1
      REAL*8    A(NUM_DIAG, GLOBAL_N)
*
      INTEGER   I, J
      REAL*8    INV_H

      INV_H = GLOBAL_M1 * GLOBAL_M1

*     DIAGONAL ELEMENTS

      DO I = 1, GLOBAL_N - GLOBAL_M1, GLOBAL_M1
          DO J = I, I + GLOBAL_M1 - 2
              A(3, J) = 4 * INV_H
          END DO
          A(3, J) = 2 * INV_H
      END DO
      DO J = I, I + GLOBAL_M1 - 2
          A(3, J) = 2 * INV_H
      END DO
      A(3, J) = 1 * INV_H

*     OFF-DIAGONAL ELEMENTS

      DO I = 1, GLOBAL_N - GLOBAL_M1, GLOBAL_M1
          A(2, I) = 0
          DO J = I, I + GLOBAL_M1 - 2
              A(2, J + 1) = -1 * INV_H
              A(4, J) = -1 * INV_H
          END DO
          A(4, J) = 0
      END DO
      A(2, I) = 0
      DO J = I, I + GLOBAL_M1 - 2
          A(2, J + 1) = -.5 * INV_H
          A(4, J) = -.5 * INV_H
      END DO
      A(4, J) = 0


      DO I = 1, GLOBAL_M1
          A(1, I) = 0
          A(5, GLOBAL_N - I + 1) = 0
      END DO

      DO I = GLOBAL_M1 + 1, GLOBAL_N, GLOBAL_M1
          DO J = I, I + GLOBAL_M1 - 2
              A(1, J) = -1 * INV_H
              A(5, J - GLOBAL_M1) = -1 * INV_H
          END DO
          A(1, J) = -.5 * INV_H
          A(5, J - GLOBAL_M1) = -.5 * INV_H
      END DO

      RETURN
      END
